/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.reader;

import com.codepoetics.protonpack.StreamUtils;
import de.jungblut.math.DoubleVector;
import de.jungblut.online.ml.FeatureOutcomePair;
import java.util.Arrays;
import java.util.stream.Stream;

public class Dataset {
    protected final DoubleVector[] features;
    protected final DoubleVector[] outcomes;
    protected String[] featureNames;
    protected String[] classNames;

    public Dataset(DoubleVector[] features, DoubleVector[] outcomes) {
        this.features = features;
        this.outcomes = outcomes;
    }

    public boolean hasFeatureNames() {
        return this.featureNames != null;
    }

    public boolean hasClassNames() {
        return this.classNames != null;
    }

    public void setClassNames(String[] classNames) {
        this.classNames = classNames;
    }

    public void setFeatureNames(String[] featureNames) {
        this.featureNames = featureNames;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public String[] getFeatureNames() {
        return this.featureNames;
    }

    public DoubleVector[] getFeatures() {
        return this.features;
    }

    public DoubleVector[] getOutcomes() {
        return this.outcomes;
    }

    public Stream<FeatureOutcomePair> asStream() {
        Stream<DoubleVector> left = Arrays.stream(this.getFeatures());
        Stream<DoubleVector> right = Arrays.stream(this.getOutcomes());
        return StreamUtils.zip(left, right, (l, r) -> new FeatureOutcomePair((DoubleVector)l, (DoubleVector)r));
    }
}

