/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.reader;

import au.com.bytecode.opencsv.CSVReader;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.dense.DenseDoubleVector;
import de.jungblut.math.dense.SingleEntryDoubleVector;
import de.jungblut.reader.Dataset;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;

public final class CsvDatasetReader {
    private CsvDatasetReader() {
        throw new IllegalAccessError();
    }

    public static Dataset readCsv(String path, char separator, Character quote, int outcomeIndex, boolean skipHeader, boolean cacheOutcomeVectors) {
        ArrayList<DenseDoubleVector> featureList = new ArrayList<DenseDoubleVector>();
        ArrayList<SingleEntryDoubleVector> outcomeList = new ArrayList<SingleEntryDoubleVector>();
        HashMap<Integer, SingleEntryDoubleVector> cacheMap = new HashMap<Integer, SingleEntryDoubleVector>();
        try (FileReader fr = new FileReader(path);){
            String[] line;
            CSVReader reader = null;
            reader = quote == null ? new CSVReader((Reader)fr, separator) : new CSVReader((Reader)fr, separator, quote.charValue());
            if (skipHeader) {
                reader.readNext();
            }
            while ((line = reader.readNext()) != null) {
                double[] fArray = new double[line.length - 1];
                int index = 0;
                for (int i = 0; i < line.length; ++i) {
                    if (i == outcomeIndex) continue;
                    fArray[index++] = Double.parseDouble(line[i]);
                }
                DenseDoubleVector f = new DenseDoubleVector(fArray);
                featureList.add(f);
                SingleEntryDoubleVector o = new SingleEntryDoubleVector(Double.parseDouble(line[outcomeIndex]));
                if (cacheOutcomeVectors) {
                    int key = (int)o.get(0);
                    SingleEntryDoubleVector cached = (SingleEntryDoubleVector)cacheMap.get(key);
                    if (cached == null) {
                        cacheMap.put(key, o);
                    } else {
                        o = cached;
                    }
                }
                outcomeList.add(o);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DoubleVector[] features = featureList.toArray(new DoubleVector[featureList.size()]);
        DoubleVector[] outcome = outcomeList.toArray(new DoubleVector[outcomeList.size()]);
        return new Dataset(features, outcome);
    }
}

