/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.partition;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.io.WritableComparable;

public class Boundaries {
    private final Set<Range> boundaries = new TreeSet<Range>();

    Boundaries() {
    }

    void addRange(int start, int end) {
        this.boundaries.add(new Range(start, end));
    }

    void splitRange(int start, int split, int end) {
        Range old = new Range(start, end);
        this.boundaries.remove(old);
        this.boundaries.add(new Range(start, split - 1));
        this.boundaries.add(new Range(split + 1, end));
    }

    public void removeRow(int row) {
        Range found = this.searchContainingBound(row);
        if (found.start == row) {
            this.boundaries.add(new Range(found.start + 1, found.end));
            this.boundaries.remove(found);
        } else if (found.end == row) {
            this.boundaries.add(new Range(found.start, found.end - 1));
            this.boundaries.remove(found);
        } else {
            this.splitRange(found.start, row, found.end);
        }
    }

    private Range searchContainingBound(int row) {
        for (Range r : this.boundaries) {
            if (r.start > row || r.end < row) continue;
            return r;
        }
        return null;
    }

    public Set<Range> getBoundaries() {
        return this.boundaries;
    }

    public String toString() {
        return "Boundaries [boundaries=" + this.boundaries + "]";
    }

    public static class Range
    implements WritableComparable<Range> {
        private int start;
        private int end;

        public Range() {
        }

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.end;
            result = 31 * result + this.start;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Range other = (Range)obj;
            return this.end == other.end && this.start == other.start;
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.start);
            out.writeInt(this.end);
        }

        public void readFields(DataInput in) throws IOException {
            this.start = in.readInt();
            this.end = in.readInt();
        }

        public String toString() {
            return "Range [start=" + this.start + ", end=" + this.end + "]";
        }

        public int compareTo(Range o) {
            return this.start < o.start ? -1 : (this.start == o.start ? 0 : 1);
        }
    }
}

