/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.partition;

import com.google.common.base.Preconditions;
import de.jungblut.partition.Boundaries;
import de.jungblut.partition.Partitioner;

public class BlockPartitioner
implements Partitioner {
    @Override
    public Boundaries partition(int sizeOfCluster, int numberOfRows) {
        Preconditions.checkArgument((sizeOfCluster != 0 ? 1 : 0) != 0, (Object)("Size of Cluster should not be 0! Given: " + sizeOfCluster));
        Boundaries bounds = new Boundaries();
        int avg = Math.round(numberOfRows / sizeOfCluster);
        int neededSplits = sizeOfCluster;
        int start = 0;
        while (neededSplits > 0) {
            bounds.addRange(start, start += avg - 1);
            int leftPieces = numberOfRows - ++start;
            if (--neededSplits <= 0) continue;
            avg = leftPieces / neededSplits;
        }
        return bounds;
    }
}

