/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.nlp.model;

import java.util.Arrays;
import java.util.Collection;

public final class ReferencedContext<REF_TYPE, CONTEXT_TYPE> {
    private final REF_TYPE reference;
    private final Collection<CONTEXT_TYPE> context;

    @SafeVarargs
    public ReferencedContext(REF_TYPE reference, CONTEXT_TYPE ... context) {
        this(reference, (Collection<CONTEXT_TYPE>)Arrays.asList(context));
    }

    public ReferencedContext(REF_TYPE reference, Collection<CONTEXT_TYPE> context) {
        this.reference = reference;
        this.context = context;
    }

    public REF_TYPE getReference() {
        return this.reference;
    }

    public Collection<CONTEXT_TYPE> getContext() {
        return this.context;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferencedContext other = (ReferencedContext)obj;
        return !(this.reference == null ? other.reference != null : !this.reference.equals(other.reference));
    }

    public String toString() {
        return "ReferencedContext [reference=" + this.reference + ", context=" + this.context + "]";
    }
}

