/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.nlp;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import de.jungblut.datastructure.ArrayUtils;
import de.jungblut.math.DoubleVector;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public final class MinHash {
    private final int numHashes;
    private final HashFunction[] functions;

    private MinHash(int numHashes) {
        this(numHashes, HashType.LINEAR, System.currentTimeMillis());
    }

    private MinHash(int numHashes, HashType type) {
        this(numHashes, type, System.currentTimeMillis());
    }

    private MinHash(int numHashes, HashType type, long seed) {
        this.numHashes = numHashes;
        this.functions = new HashFunction[numHashes];
        Random r = new Random(seed);
        block5: for (int i = 0; i < numHashes; ++i) {
            switch (type) {
                case LINEAR: {
                    this.functions[i] = new LinearHashFunction(r.nextInt(), r.nextInt());
                    continue block5;
                }
                case MURMUR128: {
                    this.functions[i] = new Murmur128HashFunction(r.nextInt());
                    continue block5;
                }
                case MD5: {
                    this.functions[i] = new MD5HashFunction(r.nextInt());
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Don't know the equivalent hashfunction to: " + type);
                }
            }
        }
    }

    public int[] minHashVector(DoubleVector vector) {
        int[] minHashes = new int[this.numHashes];
        byte[] bytesToHash = new byte[4];
        Arrays.fill(minHashes, Integer.MAX_VALUE);
        for (int i = 0; i < this.numHashes; ++i) {
            Iterator iterateNonZero = vector.iterateNonZero();
            while (iterateNonZero.hasNext()) {
                DoubleVector.DoubleVectorElement next = (DoubleVector.DoubleVectorElement)iterateNonZero.next();
                int value = next.getIndex();
                bytesToHash[0] = (byte)(value >> 24);
                bytesToHash[1] = (byte)(value >> 16);
                bytesToHash[2] = (byte)(value >> 8);
                bytesToHash[3] = (byte)value;
                int hash = this.functions[i].hash(bytesToHash);
                if (minHashes[i] <= hash) continue;
                minHashes[i] = hash;
            }
        }
        return minHashes;
    }

    public double measureSimilarity(int[] left, int[] right) {
        Preconditions.checkArgument((left.length == right.length ? 1 : 0) != 0, (Object)("Left length was not equal to right length! " + left.length + " != " + right.length));
        if (left.length + right.length == 0) {
            return 0.0;
        }
        int[] union = ArrayUtils.union(left, right);
        int[] intersection = ArrayUtils.intersectionUnsorted(left, right);
        return (double)intersection.length / (double)union.length;
    }

    public Set<String> createClusterKeys(int[] minHashes, int keyGroups) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.numHashes; ++i) {
            StringBuilder clusterIdBuilder = new StringBuilder();
            for (int j = 0; j < keyGroups; ++j) {
                clusterIdBuilder.append(minHashes[(i + j) % minHashes.length]).append('_');
            }
            String clusterId = clusterIdBuilder.toString();
            clusterId = clusterId.substring(0, clusterId.lastIndexOf(95));
            set.add(clusterId);
        }
        return set;
    }

    public static MinHash create(int numHashes) {
        return new MinHash(numHashes);
    }

    public static MinHash create(int numHashes, long seed) {
        return new MinHash(numHashes, HashType.LINEAR, seed);
    }

    public static MinHash create(int numHashes, HashType type) {
        return new MinHash(numHashes, type);
    }

    public static MinHash create(int numHashes, HashType type, long seed) {
        return new MinHash(numHashes, type, seed);
    }

    class MD5HashFunction
    extends HashFunction {
        com.google.common.hash.HashFunction md5;

        public MD5HashFunction(int seed) {
            super(seed);
            this.md5 = Hashing.md5();
        }

        @Override
        int hash(byte[] bytes) {
            return this.md5.hashBytes(bytes).asInt();
        }
    }

    class Murmur128HashFunction
    extends HashFunction {
        com.google.common.hash.HashFunction murmur;

        public Murmur128HashFunction(int seed) {
            super(seed);
            this.murmur = Hashing.murmur3_128((int)seed);
        }

        @Override
        int hash(byte[] bytes) {
            return this.murmur.hashBytes(bytes).asInt();
        }
    }

    class LinearHashFunction
    extends HashFunction {
        private int seed2;

        public LinearHashFunction(int seed, int seed2) {
            super(seed);
            this.seed2 = seed2;
        }

        @Override
        int hash(byte[] bytes) {
            long hashValue = 31L;
            for (byte byteVal : bytes) {
                hashValue *= (long)(this.seed * byteVal);
                hashValue += (long)this.seed2;
            }
            return Math.abs((int)(hashValue % 2147482949L));
        }
    }

    abstract class HashFunction {
        protected int seed;

        public HashFunction(int seed) {
            this.seed = seed;
        }

        abstract int hash(byte[] var1);
    }

    public static enum HashType {
        LINEAR,
        MURMUR128,
        MD5;

    }
}

