/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.nlp;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import de.jungblut.math.DoubleMatrix;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.dense.DenseDoubleVector;
import de.jungblut.math.sparse.SparseDoubleRowMatrix;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.commons.math3.util.FastMath;

public final class MarkovChain {
    private final DoubleMatrix transitionProbabilities;
    private final int numStates;

    private MarkovChain(int numStates) {
        this(numStates, (DoubleMatrix)new SparseDoubleRowMatrix(numStates, numStates));
    }

    private MarkovChain(int numStates, DoubleMatrix mat) {
        this.numStates = numStates;
        this.transitionProbabilities = mat;
    }

    public void train(Stream<int[]> states) {
        int[] rowEntries;
        Preconditions.checkArgument((!states.isParallel() ? 1 : 0) != 0, (Object)"parallel streams are not supported");
        states.forEach(array -> {
            for (int i = 0; i < ((int[])array).length - 1; ++i) {
                int count = (int)this.transitionProbabilities.get(array[i], array[i + 1]);
                this.transitionProbabilities.set(array[i], array[i + 1], (double)(++count));
            }
        });
        for (int rowIndex : rowEntries = this.transitionProbabilities.rowIndices()) {
            DoubleVector rowVector = this.transitionProbabilities.getRowVector(rowIndex);
            double sum = rowVector.sum();
            Iterator iterateNonZero = rowVector.iterateNonZero();
            while (iterateNonZero.hasNext()) {
                DoubleVector.DoubleVectorElement columnElement = (DoubleVector.DoubleVectorElement)iterateNonZero.next();
                int columnIndex = columnElement.getIndex();
                double probability = FastMath.log((double)columnElement.getValue()) - FastMath.log((double)sum);
                this.transitionProbabilities.set(rowIndex, columnIndex, probability);
            }
        }
    }

    public double getProbabilityForSequence(int[] stateSequence) {
        DoubleVector distribution = this.getTransitionProbabilities(stateSequence);
        double max = distribution.max();
        double probabilitySum = 0.0;
        for (int i = 0; i < distribution.getDimension(); ++i) {
            double probability = distribution.get(i);
            double normalizedProbability = probability - max;
            probabilitySum += normalizedProbability;
        }
        return FastMath.exp((double)probabilitySum);
    }

    public double averageTransitionProbability(int[] sequence) {
        DoubleVector distribution = this.getTransitionProbabilities(sequence);
        return FastMath.exp((double)(distribution.sum() / Math.max(1.0, (double)distribution.getLength())));
    }

    public DoubleVector getTransitionProbabilities(int[] stateSequence) {
        DenseDoubleVector distribution = new DenseDoubleVector(stateSequence.length - 1);
        for (int i = 0; i < distribution.getDimension(); ++i) {
            distribution.set(i, this.transitionProbabilities.get(stateSequence[i], stateSequence[i + 1]));
        }
        return distribution;
    }

    public int[] completeStateSequence(Optional<Random> optionalRandom, int[] stateSequence, int ... unsuppliedStateIndices) {
        Arrays.sort(unsuppliedStateIndices);
        for (int index : unsuppliedStateIndices) {
            if (index == 0) {
                if (index + 1 < stateSequence.length) {
                    if (optionalRandom.isPresent()) {
                        stateSequence[index] = MarkovChain.chooseState((Random)optionalRandom.get(), this.transitionProbabilities.getColumnVector(stateSequence[index + 1]));
                        continue;
                    }
                    stateSequence[index] = this.transitionProbabilities.getColumnVector(stateSequence[index + 1]).maxIndex();
                    continue;
                }
                throw new IllegalArgumentException("Can't guess state " + index + " in " + Arrays.toString(stateSequence));
            }
            stateSequence[index] = optionalRandom.isPresent() ? MarkovChain.chooseState((Random)optionalRandom.get(), this.transitionProbabilities.getRowVector(stateSequence[index - 1])) : this.transitionProbabilities.getRowVector(stateSequence[index - 1]).maxIndex();
        }
        return stateSequence;
    }

    private static int chooseState(Random random, DoubleVector probabilities) {
        double r = random.nextDouble();
        Iterator iterateNonZero = probabilities.iterateNonZero();
        DoubleVector.DoubleVectorElement next = null;
        while (iterateNonZero.hasNext()) {
            next = (DoubleVector.DoubleVectorElement)iterateNonZero.next();
            if (!(r <= Math.exp(next.getValue()))) continue;
            return next.getIndex();
        }
        return probabilities.maxIndex();
    }

    public DoubleMatrix getTransitionProbabilities() {
        return this.transitionProbabilities;
    }

    public int getNumStates() {
        return this.numStates;
    }

    public static MarkovChain create(int numStates) {
        return new MarkovChain(numStates);
    }

    public static MarkovChain create(int numStates, DoubleMatrix mat) {
        return new MarkovChain(numStates, mat);
    }
}

