/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.nlp;

import de.jungblut.distance.DistanceMeasurer;
import de.jungblut.math.DoubleVector;
import de.jungblut.nlp.VectorizerUtils;
import java.util.List;
import java.util.stream.Collectors;

public final class DocumentSimilarity {
    private final DistanceMeasurer measurer;

    private DocumentSimilarity(DistanceMeasurer measurer) {
        this.measurer = measurer;
    }

    public final double measureDocumentSimilarity(String[] doc1, String[] doc2) {
        List wordFrequencyVectorize = VectorizerUtils.wordFrequencyVectorize(doc1, doc2).collect(Collectors.toList());
        return 1.0 - this.measurer.measureDistance((DoubleVector)wordFrequencyVectorize.get(0), (DoubleVector)wordFrequencyVectorize.get(1));
    }

    public static DocumentSimilarity with(DistanceMeasurer measurer) {
        return new DocumentSimilarity(measurer);
    }
}

