/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.ner;

import de.jungblut.math.DoubleVector;
import de.jungblut.math.dense.SingleEntryDoubleVector;
import de.jungblut.math.sparse.SparseDoubleVector;
import de.jungblut.math.tuple.Tuple;
import de.jungblut.ner.SequenceFeatureExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class SparseFeatureExtractorHelper<K> {
    private final List<K> words;
    private final List<Integer> labels;
    private final SequenceFeatureExtractor<K> extractor;
    private final HashSet<Integer> classSet;
    private int classes;
    private String[] dicts;

    public SparseFeatureExtractorHelper(List<K> words, List<Integer> labels, SequenceFeatureExtractor<K> extractor) {
        this.words = words;
        this.labels = labels;
        this.extractor = extractor;
        this.classSet = new HashSet<Integer>(labels);
        this.classes = this.classSet.size();
    }

    public SparseFeatureExtractorHelper(List<K> words, List<Integer> labels, SequenceFeatureExtractor<K> extractor, String[] dictionary) {
        this(words, labels, extractor);
        this.dicts = dictionary;
    }

    public Tuple<DoubleVector[], DoubleVector[]> vectorize() {
        return this.extractInternal(this.words, this.labels);
    }

    public DoubleVector vectorize(K word) {
        return this.vectorize(word, null);
    }

    public DoubleVector vectorize(K word, Integer lastLabel) {
        List<String> computedFeatures = this.extractor.computeFeatures(Arrays.asList(word), lastLabel == null ? 0 : lastLabel, 0);
        SparseDoubleVector feature = new SparseDoubleVector(this.dicts.length);
        for (String feat : computedFeatures) {
            int index = Arrays.binarySearch(this.dicts, feat);
            if (index < 0) continue;
            feature.set(index, 1.0);
        }
        return feature;
    }

    public Tuple<DoubleVector[], DoubleVector[]> vectorize(List<K> words, List<Integer> labels) {
        return this.vectorizeAdditionals(words, labels);
    }

    public Tuple<DoubleVector[], DoubleVector[]> vectorizeAdditionals(List<K> words, List<Integer> labels) {
        return this.extractInternal(words, labels);
    }

    public DoubleVector[] vectorizeEachLabel(List<K> words) {
        ArrayList<List<String>> stringFeatures = new ArrayList<List<String>>();
        for (int i = 0; i < words.size(); ++i) {
            if (i == 0) {
                stringFeatures.add(this.extractor.computeFeatures(words, 0, i));
                continue;
            }
            for (int prevLabel : this.classSet) {
                stringFeatures.add(this.extractor.computeFeatures(words, prevLabel, i));
            }
        }
        DoubleVector[] features = new DoubleVector[stringFeatures.size()];
        int dimension = this.dicts.length;
        for (int i = 0; i < features.length; ++i) {
            features[i] = new SparseDoubleVector(dimension);
            for (String feat : (List)stringFeatures.get(i)) {
                int index = Arrays.binarySearch(this.dicts, feat);
                if (index < 0) continue;
                features[i].set(index, 1.0);
            }
        }
        return features;
    }

    public String[] getDictionary() {
        return this.dicts;
    }

    private Tuple<DoubleVector[], DoubleVector[]> extractInternal(List<K> words, List<Integer> labels) {
        ArrayList<List<String>> stringFeatures = new ArrayList<List<String>>();
        for (int i = 0; i < words.size(); ++i) {
            stringFeatures.add(this.extractor.computeFeatures(words, i == 0 ? 0 : labels.get(i - 1), i));
        }
        DoubleVector[] features = new DoubleVector[stringFeatures.size()];
        DoubleVector[] outcome = new DoubleVector[stringFeatures.size()];
        if (this.dicts == null) {
            HashSet set = new HashSet();
            for (List list : stringFeatures) {
                set.addAll(list);
            }
            this.dicts = set.toArray(new String[set.size()]);
            Arrays.sort(this.dicts);
        }
        int dimension = this.dicts.length;
        for (int i = 0; i < features.length; ++i) {
            features[i] = new SparseDoubleVector(dimension);
            for (String feat : (List)stringFeatures.get(i)) {
                int index = Arrays.binarySearch(this.dicts, feat);
                if (index < 0) continue;
                features[i].set(index, 1.0);
            }
            if (this.classes == 2) {
                outcome[i] = new SingleEntryDoubleVector((double)labels.get(i).intValue());
                continue;
            }
            outcome[i] = new SparseDoubleVector(this.classes);
            outcome[i].set(labels.get(i).intValue(), 1.0);
        }
        return new Tuple((Object)features, (Object)outcome);
    }
}

