/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.math.minimize;

import de.jungblut.math.DoubleVector;
import de.jungblut.math.dense.DenseDoubleVector;
import de.jungblut.math.minimize.AbstractMinimizer;
import de.jungblut.math.minimize.CostFunction;
import de.jungblut.math.tuple.Tuple;
import de.jungblut.partition.BlockPartitioner;
import de.jungblut.partition.Boundaries;
import java.util.Arrays;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ParticleSwarmOptimization
extends AbstractMinimizer {
    private static final Logger LOG = LogManager.getLogger(ParticleSwarmOptimization.class);
    private final int numParticles;
    private final double alpha;
    private final double beta;
    private final double phi;
    private final int numThreads;

    public ParticleSwarmOptimization(int numParticles, double alpha, double beta, double phi, int numThreads) {
        this.numParticles = numParticles;
        this.alpha = alpha;
        this.beta = beta;
        this.phi = phi;
        this.numThreads = numThreads;
    }

    @Override
    public final DoubleVector minimize(CostFunction f, DoubleVector pInput, int maxIterations, boolean verbose) {
        ExecutorService pool = Executors.newFixedThreadPool(this.numThreads);
        Random random = new Random();
        DoubleVector globalBestPosition = pInput;
        DoubleVector[] particlePositions = new DoubleVector[this.numParticles];
        double[] particlePersonalBestCost = new double[this.numParticles];
        for (int i = 0; i < this.numParticles; ++i) {
            particlePositions[i] = new DenseDoubleVector(Arrays.copyOf(pInput.toArray(), pInput.getLength()));
            for (int j = 0; j < particlePositions[i].getLength(); ++j) {
                particlePositions[i].set(j, particlePositions[i].get(j) + particlePositions[i].get(j) * random.nextDouble());
            }
            particlePersonalBestCost[i] = f.evaluateCost(particlePositions[i]).getCost();
        }
        Set<Boundaries.Range> boundaries = new BlockPartitioner().partition(this.numThreads, this.numParticles).getBoundaries();
        Object[] particlePersonalBestPositions = new DoubleVector[this.numParticles];
        Arrays.fill(particlePersonalBestPositions, pInput);
        double globalCost = f.evaluateCost(pInput).getCost();
        for (int iteration = 0; iteration < maxIterations; ++iteration) {
            ExecutorCompletionService<Tuple<Double, DoubleVector>> service = new ExecutorCompletionService<Tuple<Double, DoubleVector>>(pool);
            for (Boundaries.Range r : boundaries) {
                service.submit(new CallableOptimization(f, pInput.getDimension(), globalCost, r, particlePositions, particlePersonalBestCost, (DoubleVector[])particlePersonalBestPositions, globalBestPosition));
            }
            for (int i = 0; i < boundaries.size(); ++i) {
                try {
                    Tuple tuple;
                    Future poll = service.take();
                    if (poll == null || (tuple = (Tuple)poll.get()) == null || !((Double)tuple.getFirst() < globalCost)) continue;
                    globalCost = (Double)tuple.getFirst();
                    globalBestPosition = (DoubleVector)tuple.getSecond();
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            if (!verbose) continue;
            LOG.info("Iteration " + iteration + " | Cost: " + globalCost);
            this.onIterationFinished(iteration, globalCost, globalBestPosition);
        }
        pool.shutdownNow();
        return globalBestPosition;
    }

    public static DoubleVector minimizeFunction(CostFunction f, DoubleVector pInput, int numParticles, double alpha, double beta, double phi, int maxIterations, int numThreads, boolean verbose) {
        return new ParticleSwarmOptimization(numParticles, alpha, beta, phi, numThreads).minimize(f, pInput, maxIterations, verbose);
    }

    private final class CallableOptimization
    implements Callable<Tuple<Double, DoubleVector>> {
        private final Random random = new Random();
        private final Boundaries.Range range;
        private final DoubleVector[] particlePositions;
        private final double[] particlePersonalBestCost;
        private final DoubleVector[] particlePersonalBestPositions;
        private final int dim;
        private final CostFunction f;
        private DoubleVector globalBestPosition;
        private double globalCost;

        public CallableOptimization(CostFunction f, int dim, double globalCost, Boundaries.Range range, DoubleVector[] particlePositions, double[] particlePersonalBestCost, DoubleVector[] particlePersonalBestPositions, DoubleVector globalBestPosition) {
            this.f = f;
            this.dim = dim;
            this.globalCost = globalCost;
            this.range = range;
            this.particlePositions = particlePositions;
            this.particlePersonalBestCost = particlePersonalBestCost;
            this.particlePersonalBestPositions = particlePersonalBestPositions;
            this.globalBestPosition = globalBestPosition;
        }

        @Override
        public Tuple<Double, DoubleVector> call() throws Exception {
            for (int particleIndex = this.range.getStart(); particleIndex < this.range.getEnd(); ++particleIndex) {
                DoubleVector currentPosition = this.particlePositions[particleIndex];
                DoubleVector currentBest = this.particlePersonalBestPositions[particleIndex];
                DenseDoubleVector vec = new DenseDoubleVector(this.dim);
                for (int index = 0; index < vec.getDimension(); ++index) {
                    double value = ParticleSwarmOptimization.this.phi * currentPosition.get(index) + ParticleSwarmOptimization.this.alpha * this.random.nextDouble() * (currentBest.get(index) - currentPosition.get(index)) + ParticleSwarmOptimization.this.beta * this.random.nextDouble() * (this.globalBestPosition.get(index) - currentPosition.get(index));
                    vec.set(index, value);
                }
                this.particlePositions[particleIndex] = vec;
                double cost = this.f.evaluateCost((DoubleVector)vec).getCost();
                if (!(cost < this.particlePersonalBestCost[particleIndex])) continue;
                this.particlePersonalBestCost[particleIndex] = cost;
                this.particlePersonalBestPositions[particleIndex] = vec;
                if (!(cost < this.globalCost)) continue;
                this.globalCost = cost;
                this.globalBestPosition = vec;
            }
            return new Tuple((Object)this.globalCost, (Object)this.globalBestPosition);
        }
    }
}

