/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.math.minimize;

import de.jungblut.math.DoubleVector;
import de.jungblut.math.minimize.AbstractMinimizer;
import de.jungblut.math.minimize.CostFunction;
import de.jungblut.math.minimize.CostGradientTuple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Fmincg
extends AbstractMinimizer {
    private static final Logger LOG = LogManager.getLogger(Fmincg.class);
    public static double EXT = 3.0;
    private static final double RHO = 0.01;
    private static final double SIG = 0.5;
    private static final double INT = 0.1;
    private static final int MAX = 20;
    private static final int RATIO = 100;

    public static DoubleVector minimizeFunction(CostFunction f, DoubleVector theta, int maxIterations, boolean verbose) {
        return new Fmincg().minimize(f, theta, maxIterations, verbose);
    }

    @Override
    public final DoubleVector minimize(CostFunction f, DoubleVector theta, int length, boolean verbose) {
        DoubleVector input = theta;
        int M = 0;
        int i = 0;
        boolean red = true;
        boolean ls_failed = false;
        CostGradientTuple evaluateCost = f.evaluateCost(input);
        double f1 = evaluateCost.getCost();
        DoubleVector df1 = evaluateCost.getGradient();
        i += length < 0 ? 1 : 0;
        DoubleVector s = df1.multiply(-1.0);
        double d1 = s.multiply(-1.0).dot(s);
        double z1 = (double)red / (1.0 - d1);
        while (i < Math.abs(length)) {
            i += length > 0 ? 1 : 0;
            DoubleVector X0 = input.deepCopy();
            double f0 = f1;
            DoubleVector df0 = df1.deepCopy();
            input = input.add(s.multiply(z1));
            CostGradientTuple evaluateCost2 = f.evaluateCost(input);
            double f2 = evaluateCost2.getCost();
            DoubleVector df2 = evaluateCost2.getGradient();
            double d2 = df2.dot(s);
            double f3 = f1;
            double d3 = d1;
            double z3 = -z1;
            M = length > 0 ? 20 : Math.min(20, -length - (i += length < 0 ? 1 : 0));
            boolean success = false;
            double limit = -1.0;
            while (true) {
                CostGradientTuple evaluateCost3;
                if (f2 > f1 + z1 * 0.01 * d1 | d2 > -0.5 * d1 && M > 0) {
                    limit = z1;
                    double z2 = 0.0;
                    double A = 0.0;
                    double B = 0.0;
                    if (f2 > f1) {
                        z2 = z3 - 0.5 * d3 * z3 * z3 / (d3 * z3 + f2 - f3);
                    } else {
                        A = 6.0 * (f2 - f3) / z3 + 3.0 * (d2 + d3);
                        B = 3.0 * (f3 - f2) - z3 * (d3 + 2.0 * d2);
                        z2 = (Math.sqrt(B * B - A * d2 * z3 * z3) - B) / A;
                    }
                    if (Double.isNaN(z2) || Double.isInfinite(z2)) {
                        z2 = z3 / 2.0;
                    }
                    z2 = Math.max(Math.min(z2, 0.1 * z3), 0.9 * z3);
                    z1 += z2;
                    input = input.add(s.multiply(z2));
                    evaluateCost3 = f.evaluateCost(input);
                    f2 = evaluateCost3.getCost();
                    df2 = evaluateCost3.getGradient();
                    --M;
                    i += length < 0 ? 1 : 0;
                    d2 = df2.dot(s);
                    z3 -= z2;
                    continue;
                }
                if (f2 > f1 + z1 * 0.01 * d1 || d2 > -0.5 * d1) break;
                if (d2 > 0.5 * d1) {
                    success = true;
                    break;
                }
                if (M == 0) break;
                double B = 3.0 * (f3 - f2) - z3 * (d3 + 2.0 * d2);
                double A = 6.0 * (f2 - f3) / z3 + 3.0 * (d2 + d3);
                double z2 = -d2 * z3 * z3 / (B + Math.sqrt(B * B - A * d2 * z3 * z3));
                if (Double.isNaN(z2) || Double.isInfinite(z2) || z2 < 0.0) {
                    z2 = limit < -0.5 ? z1 * (EXT - 1.0) : (limit - z1) / 2.0;
                } else if (limit > -0.5 && z2 + z1 > limit) {
                    z2 = (limit - z1) / 2.0;
                } else if (limit < -0.5 && z2 + z1 > z1 * EXT) {
                    z2 = z1 * (EXT - 1.0);
                } else if (z2 < -z3 * 0.1) {
                    z2 = -z3 * 0.1;
                } else if (limit > -0.5 && z2 < (limit - z1) * 0.9) {
                    z2 = (limit - z1) * 0.9;
                }
                f3 = f2;
                d3 = d2;
                z3 = -z2;
                z1 += z2;
                input = input.add(s.multiply(z2));
                evaluateCost3 = f.evaluateCost(input);
                f2 = evaluateCost3.getCost();
                df2 = evaluateCost3.getGradient();
                --M;
                i += length < 0 ? 1 : 0;
                d2 = df2.dot(s);
            }
            DoubleVector tmp = null;
            if (success) {
                f1 = f2;
                if (verbose) {
                    LOG.info("Iteration " + i + " | Cost: " + f1);
                }
                this.onIterationFinished(i, f1, input);
                double numerator = (df2.dot(df2) - df1.dot(df2)) / df1.dot(df1);
                s = s.multiply(numerator).subtract(df2);
                tmp = df1;
                df1 = df2;
                df2 = tmp;
                d2 = df1.dot(s);
                if (d2 > 0.0) {
                    s = df1.multiply(-1.0);
                    d2 = s.multiply(-1.0).dot(s);
                }
                z1 *= Math.min(100.0, d1 / (d2 - 2.2251E-308));
                d1 = d2;
                ls_failed = false;
                continue;
            }
            input = X0;
            f1 = f0;
            df1 = df0;
            if (ls_failed || i > Math.abs(length)) break;
            tmp = df1;
            df1 = df2;
            df2 = tmp;
            s = df1.multiply(-1.0);
            d1 = s.multiply(-1.0).dot(s);
            z1 = 1.0 / (1.0 - d1);
            ls_failed = true;
        }
        return input;
    }
}

