/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.math.minimize;

import de.jungblut.math.DoubleMatrix;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.dense.DenseDoubleMatrix;
import de.jungblut.math.dense.DenseDoubleVector;

public abstract class DenseMatrixFolder {
    public static DoubleVector foldMatrices(DoubleMatrix ... matrices) {
        int length = 0;
        for (DoubleMatrix matrix : matrices) {
            length += matrix.getRowCount() * matrix.getColumnCount();
        }
        DenseDoubleVector v = new DenseDoubleVector(length);
        int index = 0;
        for (DoubleMatrix matrix : matrices) {
            for (int j = 0; j < matrix.getColumnCount(); ++j) {
                for (int i = 0; i < matrix.getRowCount(); ++i) {
                    v.set(index++, matrix.get(i, j));
                }
            }
        }
        return v;
    }

    public static DoubleMatrix[] unfoldMatrices(DoubleVector vector, int[][] sizeArray) {
        DoubleMatrix[] arr = new DoubleMatrix[sizeArray.length];
        for (int i = 0; i < sizeArray.length; ++i) {
            arr[i] = new DenseDoubleMatrix(sizeArray[i][0], sizeArray[i][1]);
        }
        int currentVectorIndex = 0;
        for (int i = 0; i < arr.length; ++i) {
            int numRows = sizeArray[i][0];
            int numColumns = sizeArray[i][1];
            for (int col = 0; col < numColumns; ++col) {
                for (int row = 0; row < numRows; ++row) {
                    arr[i].set(row, col, vector.get(currentVectorIndex++));
                }
            }
        }
        return arr;
    }

    public static DoubleMatrix unfoldMatrix(DoubleVector vector, int rows, int cols) {
        DenseDoubleMatrix mat = new DenseDoubleMatrix(rows, cols);
        int index = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                mat.set(i, j, vector.get(index++));
            }
        }
        return mat;
    }

    public static DoubleVector foldMatrix(DoubleMatrix mat) {
        DenseDoubleVector vec = new DenseDoubleVector(mat.getRowCount() * mat.getColumnCount());
        int index = 0;
        for (int i = 0; i < mat.getRowCount(); ++i) {
            for (int j = 0; j < mat.getColumnCount(); ++j) {
                vec.set(index++, mat.get(i, j));
            }
        }
        return vec;
    }
}

