/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.math.loss;

import de.jungblut.math.DoubleMatrix;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.MathUtils;
import de.jungblut.math.loss.LossFunction;
import de.jungblut.math.sparse.SequentialSparseDoubleVector;
import java.util.Iterator;

public class StepLoss
implements LossFunction {
    @Override
    public double calculateLoss(DoubleMatrix y, DoubleMatrix hypothesis) {
        return y.subtract(hypothesis).sum() / (double)y.getRowCount();
    }

    @Override
    public double calculateLoss(DoubleVector y, DoubleVector hypothesis) {
        return y.subtract(hypothesis).sum();
    }

    @Override
    public DoubleVector calculateGradient(DoubleVector feature, DoubleVector y, DoubleVector hypothesis) {
        double error = y.subtract(hypothesis).sum();
        if (error != 0.0) {
            DoubleVector result = feature.deepCopy();
            Iterator iterateNonZero = feature.iterateNonZero();
            while (iterateNonZero.hasNext()) {
                DoubleVector.DoubleVectorElement next = (DoubleVector.DoubleVectorElement)iterateNonZero.next();
                result.set(next.getIndex(), MathUtils.guardedLogarithm(next.getValue() + 1.0) * error * -1.0);
            }
            return result;
        }
        return new SequentialSparseDoubleVector(feature.getDimension());
    }
}

