/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.math.loss;

import de.jungblut.math.DoubleMatrix;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.loss.LossFunction;
import org.apache.commons.math3.util.FastMath;

public class HingeLoss
implements LossFunction {
    @Override
    public double calculateLoss(DoubleMatrix y, DoubleMatrix hypothesis) {
        DoubleMatrix multiplyElementWise = y.multiplyElementWise(hypothesis);
        double sum = 0.0;
        for (int i = 0; i < multiplyElementWise.getRowCount(); ++i) {
            sum += FastMath.max((double)0.0, (double)(1.0 - multiplyElementWise.get(i, 0)));
        }
        return sum / (double)multiplyElementWise.getRowCount();
    }

    @Override
    public double calculateLoss(DoubleVector y, DoubleVector hypothesis) {
        DoubleVector v = y.multiply(hypothesis);
        return FastMath.max((double)0.0, (double)(1.0 - v.get(0)));
    }

    @Override
    public DoubleVector calculateGradient(DoubleVector feature, DoubleVector y, DoubleVector hypothesis) {
        DoubleVector v = y.multiply(hypothesis);
        if (v.get(0) > 1.0) {
            return feature.multiply(0.0);
        }
        return feature.multiply(y.multiply(-1.0).get(0));
    }
}

