/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.math.activation;

import de.jungblut.math.activation.AbstractActivationFunction;
import org.apache.commons.math3.util.FastMath;

public final class SigmoidActivationFunction
extends AbstractActivationFunction {
    private static final double CLIP = 30.0;

    @Override
    public double apply(double input) {
        return SigmoidActivationFunction.sigmoid(input);
    }

    @Override
    public double gradient(double input) {
        return SigmoidActivationFunction.sigmoidGradient(input);
    }

    static double sigmoid(double input) {
        double clipped = FastMath.min((double)30.0, (double)FastMath.max((double)-30.0, (double)input));
        return 1.0 / (1.0 + FastMath.exp((double)(-clipped)));
    }

    static double sigmoidGradient(double input) {
        double s = SigmoidActivationFunction.sigmoid(input);
        return s * (1.0 - s);
    }
}

