/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.math.activation;

import de.jungblut.math.activation.AbstractActivationFunction;

public final class ElliotActivationFunction
extends AbstractActivationFunction {
    @Override
    public double apply(double input) {
        return ElliotActivationFunction.elliot(input);
    }

    @Override
    public double gradient(double input) {
        return ElliotActivationFunction.elliotGradient(input);
    }

    static double elliot(double input) {
        return input / 2.0 / (1.0 + Math.abs(input)) + 0.5;
    }

    static double elliotGradient(double input) {
        double denom = 1.0 + Math.abs(input);
        return 1.0 / (denom * denom) * 2.0;
    }
}

