/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.math.activation;

import de.jungblut.math.DoubleMatrix;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.activation.ActivationFunction;
import de.jungblut.math.dense.DenseDoubleMatrix;
import de.jungblut.math.dense.DenseDoubleVector;
import de.jungblut.math.sparse.SparseDoubleRowMatrix;
import de.jungblut.math.sparse.SparseDoubleVector;
import java.util.Iterator;

public abstract class AbstractActivationFunction
implements ActivationFunction {
    @Override
    public DoubleVector apply(DoubleVector vector) {
        DoubleVector newInstance = this.newInstance(vector);
        if (vector.isSparse()) {
            Iterator iterateNonZero = vector.iterateNonZero();
            while (iterateNonZero.hasNext()) {
                DoubleVector.DoubleVectorElement next = (DoubleVector.DoubleVectorElement)iterateNonZero.next();
                newInstance.set(next.getIndex(), this.apply(next.getValue()));
            }
        } else {
            for (int i = 0; i < vector.getDimension(); ++i) {
                newInstance.set(i, this.apply(vector.get(i)));
            }
        }
        return newInstance;
    }

    @Override
    public DoubleMatrix apply(DoubleMatrix matrix) {
        DoubleMatrix newInstance = this.newInstance(matrix);
        if (matrix.isSparse()) {
            int[] rows;
            for (int row : rows = matrix.rowIndices()) {
                DoubleVector rowVector = matrix.getRowVector(row);
                if (rowVector.getLength() <= 0) continue;
                DoubleVector apply = this.apply(rowVector);
                newInstance.setRowVector(row, apply);
            }
        } else {
            for (int i = 0; i < matrix.getRowCount(); ++i) {
                for (int j = 0; j < matrix.getColumnCount(); ++j) {
                    newInstance.set(i, j, this.apply(matrix.get(i, j)));
                }
            }
        }
        return newInstance;
    }

    @Override
    public DoubleVector gradient(DoubleVector vector) {
        DoubleVector newInstance = this.newInstance(vector);
        if (vector.isSparse()) {
            Iterator iterateNonZero = vector.iterateNonZero();
            while (iterateNonZero.hasNext()) {
                DoubleVector.DoubleVectorElement next = (DoubleVector.DoubleVectorElement)iterateNonZero.next();
                newInstance.set(next.getIndex(), this.gradient(next.getValue()));
            }
        } else {
            for (int i = 0; i < vector.getDimension(); ++i) {
                newInstance.set(i, this.gradient(vector.get(i)));
            }
        }
        return newInstance;
    }

    @Override
    public DoubleMatrix gradient(DoubleMatrix matrix) {
        DoubleMatrix newInstance = this.newInstance(matrix);
        if (matrix.isSparse()) {
            int[] columnIndices;
            for (int col : columnIndices = matrix.columnIndices()) {
                newInstance.setColumnVector(col, this.gradient(matrix.getColumnVector(col)));
            }
        } else {
            for (int i = 0; i < matrix.getRowCount(); ++i) {
                for (int j = 0; j < matrix.getColumnCount(); ++j) {
                    newInstance.set(i, j, this.gradient(matrix.get(i, j)));
                }
            }
        }
        return newInstance;
    }

    protected DoubleMatrix newInstance(DoubleMatrix mat) {
        if (mat.isSparse()) {
            return new SparseDoubleRowMatrix(mat.getRowCount(), mat.getColumnCount());
        }
        return new DenseDoubleMatrix(mat.getRowCount(), mat.getColumnCount());
    }

    protected DoubleVector newInstance(DoubleVector v) {
        if (v.isSparse()) {
            return new SparseDoubleVector(v.getDimension());
        }
        return new DenseDoubleVector(v.getDimension());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

