/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.distance;

import de.jungblut.distance.DistanceMeasurer;
import de.jungblut.math.DoubleVector;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

public final class HaversineDistance
implements DistanceMeasurer {
    private static final double EARTH_RADIUS_IN_METERS = 6372797.560856;

    @Override
    public final double measureDistance(double[] a, double[] b) {
        a = Arrays.copyOf(a, 2);
        b = Arrays.copyOf(b, 2);
        a[0] = a[0] / 180.0 * Math.PI;
        a[1] = a[1] / 180.0 * Math.PI;
        b[0] = b[0] / 180.0 * Math.PI;
        b[1] = b[1] / 180.0 * Math.PI;
        return FastMath.acos((double)(FastMath.sin((double)a[0]) * FastMath.sin((double)b[0]) + FastMath.cos((double)a[0]) * FastMath.cos((double)b[0]) * FastMath.cos((double)(a[1] - b[1])))) * 6372797.560856;
    }

    @Override
    public final double measureDistance(DoubleVector vec1, DoubleVector vec2) {
        return this.measureDistance(vec1.toArray(), vec2.toArray());
    }
}

