/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.distance;

import de.jungblut.distance.DistanceMeasurer;
import de.jungblut.math.DoubleVector;
import org.apache.commons.math3.util.FastMath;

public final class EuclidianDistance
implements DistanceMeasurer {
    private static final EuclidianDistance DISTANCE = new EuclidianDistance();

    @Override
    public double measureDistance(double[] set1, double[] set2) {
        double sum = 0.0;
        int length = set1.length;
        for (int i = 0; i < length; ++i) {
            double diff = set2[i] - set1[i];
            sum += diff * diff;
        }
        return FastMath.sqrt((double)sum);
    }

    @Override
    public double measureDistance(DoubleVector vec1, DoubleVector vec2) {
        if (vec1.isSparse() || vec2.isSparse()) {
            return FastMath.sqrt((double)vec2.subtract(vec1).pow(2.0).sum());
        }
        return this.measureDistance(vec1.toArray(), vec2.toArray());
    }

    public static EuclidianDistance get() {
        return DISTANCE;
    }
}

