/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import com.google.common.collect.AbstractIterator;
import de.jungblut.datastructure.InputProvider;
import de.jungblut.datastructure.Iterables;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;

public class TextLineInputProvider
extends InputProvider<String> {
    private Path path;

    public TextLineInputProvider(String path) {
        this.path = Paths.get(path, new String[0]);
    }

    public TextLineInputProvider(URI path) {
        this.path = Paths.get(path);
    }

    public TextLineInputProvider(Path path) {
        this.path = path;
    }

    @Override
    public Iterable<String> iterate() {
        try {
            final BufferedReader br = new BufferedReader(new FileReader(this.path.toFile()));
            return Iterables.from(new AbstractIterator<String>(){

                protected String computeNext() {
                    try {
                        String line = br.readLine();
                        if (line != null) {
                            return line;
                        }
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return (String)this.endOfData();
                }
            });
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }
}

