/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public final class StackMap<K, V> {
    private final HashMap<K, V> map = new HashMap();
    private final Deque<K> stack = new ArrayDeque<K>();

    public V get(K key) {
        return this.map.get(key);
    }

    public V put(K key, V value) {
        if (!this.map.containsKey(key)) {
            this.stack.push(key);
            return this.map.put(key, value);
        }
        return null;
    }

    public Map.Entry<K, V> peek() {
        K key = this.stack.peek();
        V value = this.map.get(key);
        return new StackMapEntry<K, V>(key, value);
    }

    public Map.Entry<K, V> pop() {
        K key = this.stack.pop();
        V value = this.map.remove(key);
        return new StackMapEntry<K, V>(key, value);
    }

    public class StackMapEntry<KEY, VALUE>
    implements Map.Entry<KEY, VALUE> {
        private final KEY key;
        private final VALUE value;

        public StackMapEntry(KEY key, VALUE value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public KEY getKey() {
            return this.key;
        }

        @Override
        public VALUE getValue() {
            return this.value;
        }

        @Override
        public VALUE setValue(VALUE value) {
            throw new UnsupportedOperationException("Seting the value is not allowed in immutable environments!");
        }
    }
}

