/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import de.jungblut.datastructure.Merger;
import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.IndexedSorter;
import org.apache.hadoop.util.QuickSort;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SortedFile<M extends WritableComparable>
implements IndexedSortable,
Closeable {
    private static final Logger LOG = LogManager.getLogger(SortedFile.class);
    private static final float SPILL_TRIGGER_BUFFER_FILL_PERCENTAGE = 0.9f;
    private static final IndexedSorter SORTER = new QuickSort();
    private final String dir;
    private final String destinationFileName;
    private final WritableComparator comp;
    private final DataOutputBuffer buf;
    private final int bufferThresholdSize;
    private int fileCount;
    private List<File> files;
    private TIntArrayList offsets;
    private TIntArrayList indices;
    private int size;
    private boolean mergeFiles;
    private Class<M> msgClass;
    private boolean intermediateMerge;

    public SortedFile(String dir, String finalFileName, int bufferSize, Class<M> msgClass) throws IOException {
        this(dir, finalFileName, bufferSize, msgClass, true, false);
    }

    public SortedFile(String dir, String finalFileName, int bufferSize, Class<M> msgClass, boolean intermediateMerge) throws IOException {
        this(dir, finalFileName, bufferSize, msgClass, true, intermediateMerge);
    }

    SortedFile(String dir, String finalFileName, int bufferSize, Class<M> msgClass, boolean mergeFiles, boolean intermediateMerge) throws IOException {
        this.dir = dir;
        this.destinationFileName = finalFileName;
        this.msgClass = msgClass;
        this.mergeFiles = mergeFiles;
        this.intermediateMerge = intermediateMerge;
        Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]);
        this.bufferThresholdSize = (int)((float)bufferSize * 0.9f);
        WritableComparable instance = (WritableComparable)ReflectionUtils.newInstance(msgClass, null);
        this.comp = WritableComparator.get(msgClass);
        this.buf = new DataOutputBuffer(bufferSize);
        this.offsets = new TIntArrayList();
        this.indices = new TIntArrayList();
        this.files = new ArrayList<File>();
    }

    public void collect(M msg) throws IOException {
        this.offsets.add(this.buf.getLength());
        msg.write((DataOutput)this.buf);
        this.indices.add(this.size);
        ++this.size;
        if (this.buf.getLength() > this.bufferThresholdSize) {
            this.sortAndSpill(this.buf.getLength());
            this.offsets.clear();
            this.indices.clear();
            this.buf.reset();
            this.size = 0;
        }
    }

    private void sortAndSpill(int bufferEnd) throws IOException {
        this.offsets.add(bufferEnd);
        SORTER.sort((IndexedSortable)this, 0, this.size);
        File file = new File(this.dir, this.fileCount + ".bin");
        try (DataOutputStream os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            os.writeInt(this.size);
            for (int index = 0; index < this.size; ++index) {
                int x = this.indices.get(index);
                int off = this.offsets.get(x);
                int follow = x + 1;
                int len = this.offsets.get(follow) - off;
                WritableUtils.writeVInt((DataOutput)os, (int)len);
                os.write(this.buf.getData(), off, len);
            }
        }
        this.files.add(file);
        ++this.fileCount;
    }

    public int compare(int left, int right) {
        int leftTranslated = this.indices.get(left);
        int leftEndTranslated = leftTranslated + 1;
        int rightTranslated = this.indices.get(right);
        int rightEndTranslated = rightTranslated + 1;
        int leftOffset = this.offsets.get(leftTranslated);
        int rightOffset = this.offsets.get(rightTranslated);
        int leftLen = this.offsets.get(leftEndTranslated) - leftOffset;
        int rightLen = this.offsets.get(rightEndTranslated) - rightOffset;
        return this.comp.compare(this.buf.getData(), leftOffset, leftLen, this.buf.getData(), rightOffset, rightLen);
    }

    public void swap(int left, int right) {
        int tmp = this.indices.get(left);
        this.indices.set(left, this.indices.get(right));
        this.indices.set(right, tmp);
    }

    @Override
    public void close() throws IOException {
        if (this.buf.getLength() > 0) {
            this.sortAndSpill(this.buf.getLength());
        }
        if (this.mergeFiles) {
            try {
                LOG.info("Starting" + (this.intermediateMerge ? " intermediate" : "") + " merge of " + this.files.size() + " files.");
                Merger.merge(this.msgClass, this.intermediateMerge, new File(this.destinationFileName), this.files);
            }
            catch (Throwable throwable) {
                Files.walkFileTree(Paths.get(this.dir, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (exc == null) {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                        throw exc;
                    }
                });
                throw throwable;
            }
            Files.walkFileTree(Paths.get(this.dir, new String[0]), (FileVisitor<? super Path>)new /* invalid duplicate definition of identical inner class */);
        }
    }
}

