/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import com.google.common.collect.AbstractIterator;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;

public final class SingleLinkedList<T>
extends AbstractList<T> {
    private Entry head;
    private Entry tail;
    private int size;

    public SingleLinkedList() {
    }

    public SingleLinkedList(Collection<? extends T> c) {
        this.addAll(c);
    }

    @Override
    public final boolean add(T element) {
        Entry newNode;
        Entry l = this.tail;
        this.tail = newNode = new Entry(element);
        if (l == null) {
            this.head = newNode;
        } else {
            l.next = newNode;
        }
        ++this.size;
        return true;
    }

    @Override
    public final void add(int index, T element) {
        if (index != 0) {
            if (index == this.size) {
                this.add(element);
            } else {
                Entry seek = this.seek(index - 1);
                Entry tmp = seek.next;
                seek.next = new Entry(element, tmp);
            }
        } else if (this.size == 0) {
            Entry e;
            this.head = e = new Entry(element);
            this.tail = e;
        } else {
            Entry tmp = this.head;
            this.head = new Entry(element, tmp);
        }
        ++this.size;
    }

    @Override
    public final T set(int index, T element) {
        Entry seek = this.seek(index);
        Object tmp = seek.value;
        seek.value = element;
        return tmp;
    }

    @Override
    public final T remove(int index) {
        if (index == 0) {
            Object val = this.head.value;
            this.head = this.head.next;
            --this.size;
            return val;
        }
        Entry seek = this.seek(index - 1);
        Object val = seek.next.value;
        if (index == this.size - 1) {
            this.tail = seek;
            this.tail.next = null;
        } else {
            seek.next = seek.next.next;
        }
        --this.size;
        return val;
    }

    @Override
    public final Iterator<T> iterator() {
        return new DefaultIterator();
    }

    @Override
    public final T get(int index) {
        return this.seek((int)index).value;
    }

    public final Entry seek(int index) {
        if (index == 0) {
            return this.head;
        }
        Entry ptr = this.head;
        for (int i = 0; i < index; ++i) {
            ptr = ptr.next;
        }
        return ptr;
    }

    @Override
    public final int size() {
        return this.size;
    }

    final class Entry {
        T value;
        Entry next;

        public Entry(T value) {
            this.value = value;
        }

        public Entry(T value, Entry next) {
            this.value = value;
            this.next = next;
        }
    }

    final class DefaultIterator
    extends AbstractIterator<T> {
        Entry current;

        DefaultIterator() {
        }

        protected final T computeNext() {
            this.current = this.current == null ? SingleLinkedList.this.head : this.current.next;
            if (this.current == null) {
                return this.endOfData();
            }
            return this.current.value;
        }
    }
}

