/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import com.google.common.base.Preconditions;
import de.jungblut.datastructure.ArrayUtils;
import java.util.Arrays;

public class Permutations<T extends Comparable<? super T>> {
    private final T[] array;
    private boolean firstCall = true;

    public Permutations(T[] array) {
        this.array = (Comparable[])Preconditions.checkNotNull(array, (Object)"array");
        Arrays.sort(array);
    }

    public T[] nextPermutation() {
        if (this.firstCall) {
            this.firstCall = false;
            return this.array;
        }
        int k = -1;
        for (int i = 0; i < this.array.length - 1; ++i) {
            if (this.array[i].compareTo(this.array[i + 1]) >= 0) continue;
            k = i;
        }
        if (k >= 0) {
            int j = -1;
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[k].compareTo(this.array[i]) >= 0) continue;
                j = i;
            }
            ArrayUtils.swap(this.array, k, j);
            this.reverse(k + 1);
            return this.array;
        }
        return this.end();
    }

    private void reverse(int start) {
        int idx = 0;
        int end = (this.array.length + start) / 2;
        for (int i = start; i < end; ++i) {
            ArrayUtils.swap(this.array, i, this.array.length - ++idx);
        }
    }

    private T[] end() {
        return null;
    }
}

