/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.PriorityQueue;

public final class Merger<M extends WritableComparable> {
    private final File outputFile;
    private final List<File> mergeFiles;
    private final WritableComparator comp;
    private final boolean intermediateMerge;

    private Merger(Class<M> msgClass, boolean intermediateMerge, File outputFile, List<File> list) throws IOException {
        Preconditions.checkArgument((list.size() > 0 ? 1 : 0) != 0, (Object)"Number of merged files can not be zero or negative!");
        this.intermediateMerge = intermediateMerge;
        this.outputFile = outputFile;
        this.mergeFiles = list;
        this.comp = WritableComparator.get(msgClass);
    }

    private void mergeFiles() throws IOException {
        if (this.intermediateMerge && this.mergeFiles.size() == 1) {
            FileSystems.getDefault().provider().move(Paths.get(this.mergeFiles.get(0).toURI()), Paths.get(this.outputFile.toURI()), StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        SegmentedPriorityQueue segments = new SegmentedPriorityQueue(this.mergeFiles.size());
        int sumItems = 0;
        for (int i = 0; i < this.mergeFiles.size(); ++i) {
            Segment segment = new Segment(this.mergeFiles.get(i));
            segments.put(segment);
            sumItems += segment.getItems();
        }
        int active = this.mergeFiles.size();
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.outputFile)));){
            dos.writeInt(sumItems);
            while (active > 0) {
                Segment peek = (Segment)segments.top();
                if (peek == null) {
                    break;
                }
                if (this.intermediateMerge) {
                    WritableUtils.writeVInt((DataOutput)dos, (int)peek.getLength());
                }
                dos.write(peek.getBytes(), peek.getOffset(), peek.getLength());
                if (peek.hasNext()) {
                    peek.next();
                } else {
                    peek.close();
                    segments.pop();
                    --active;
                }
                segments.adjustTop();
            }
        }
        if (!this.intermediateMerge) {
            for (File file : this.mergeFiles) {
                Files.delete(file.toPath());
            }
        }
    }

    public static <M extends WritableComparable<?>> void mergeIntermediate(Class<M> msgClass, String outputFile, String ... files) throws IOException {
        Merger.mergeIntermediate(msgClass, outputFile, Arrays.asList(files));
    }

    public static <M extends WritableComparable<?>> void mergeIntermediate(Class<M> msgClass, File outputFile, File ... files) throws IOException {
        Merger.merge(msgClass, true, outputFile, Arrays.asList(files));
    }

    public static <M extends WritableComparable<?>> void mergeIntermediate(Class<M> msgClass, File outputFile, List<File> list) throws IOException {
        Merger.merge(msgClass, true, outputFile, list);
    }

    public static <M extends WritableComparable<?>> void mergeIntermediate(Class<M> msgClass, String outputFile, List<String> list) throws IOException {
        Merger.merge(msgClass, true, new File(outputFile), Merger.toFiles(list));
    }

    public static <M extends WritableComparable<?>> void merge(Class<M> msgClass, String outputFile, String ... files) throws IOException {
        Merger.merge(msgClass, outputFile, Arrays.asList(files));
    }

    public static <M extends WritableComparable<?>> void merge(Class<M> msgClass, String outputFile, List<String> list) throws IOException {
        List<File> files = Merger.toFiles(list);
        Merger.merge(msgClass, false, new File(outputFile), files);
    }

    public static <M extends WritableComparable<?>> void merge(Class<M> msgClass, File outputFile, File ... files) throws IOException {
        Merger.merge(msgClass, false, outputFile, Arrays.asList(files));
    }

    public static <M extends WritableComparable<?>> void merge(Class<M> msgClass, File outputFile, List<File> list) throws IOException {
        Merger.merge(msgClass, false, outputFile, list);
    }

    public static <M extends WritableComparable<?>> void merge(Class<M> msgClass, boolean intermediateMerge, File outputFile, List<File> list) throws IOException {
        new Merger<M>(msgClass, intermediateMerge, outputFile, list).mergeFiles();
    }

    private static List<File> toFiles(List<String> list) {
        ArrayList<File> fList = new ArrayList<File>(list.size());
        for (String s : list) {
            fList.add(new File(s));
        }
        return fList;
    }

    final class Segment
    implements Comparable<Segment>,
    Closeable {
        private final DataOutputBuffer buf = new DataOutputBuffer();
        private final DataInputStream in;
        private int items;
        private int len = -1;

        public Segment(File f) throws IOException {
            this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
            this.items = this.in.readInt();
            this.len = WritableUtils.readVInt((DataInput)this.in);
            this.buf.write((DataInput)this.in, this.len);
        }

        public byte[] getBytes() {
            return this.buf.getData();
        }

        public int getOffset() {
            return 0;
        }

        public int getLength() {
            return this.len;
        }

        public int getItems() {
            return this.items;
        }

        public boolean hasNext() {
            return this.items > 1;
        }

        public void next() throws IOException {
            this.buf.reset();
            this.len = WritableUtils.readVInt((DataInput)this.in);
            this.buf.write((DataInput)this.in, this.len);
            --this.items;
        }

        @Override
        public int compareTo(Segment o) {
            return Merger.this.comp.compare(this.getBytes(), this.getOffset(), this.getLength(), o.getBytes(), o.getOffset(), o.getLength());
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    final class SegmentedPriorityQueue
    extends PriorityQueue<Segment> {
        public SegmentedPriorityQueue(int items) {
            this.initialize(items);
        }

        protected boolean lessThan(Object a, Object b) {
            return ((Segment)a).compareTo((Segment)b) < 0;
        }
    }
}

