/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public final class ListUtils {
    private ListUtils() {
        throw new IllegalAccessError();
    }

    public static <K extends Comparable<K>> List<K> merge(List<K> left, List<K> right) {
        Preconditions.checkNotNull(left, (Object)"left");
        Preconditions.checkNotNull(left, (Object)"right");
        ArrayList<Comparable> newList = new ArrayList<Comparable>(left.size() + right.size());
        int leftIndex = 0;
        int rightIndex = 0;
        while (leftIndex < left.size() && rightIndex < right.size()) {
            Comparable nextElement;
            Comparable rightElement;
            Comparable leftElement = (Comparable)left.get(leftIndex);
            if (leftElement.compareTo(rightElement = (Comparable)right.get(rightIndex)) <= 0) {
                nextElement = leftElement;
                ++leftIndex;
            } else {
                nextElement = rightElement;
                ++rightIndex;
            }
            ListUtils.checkConsistency(newList, nextElement);
            newList.add(nextElement);
        }
        ListUtils.fillRemainder(left, newList, leftIndex);
        ListUtils.fillRemainder(right, newList, rightIndex);
        return newList;
    }

    private static <K extends Comparable<K>> void fillRemainder(List<K> oldList, List<K> newList, int currentIndex) {
        while (currentIndex < oldList.size()) {
            Comparable nextElement = (Comparable)oldList.get(currentIndex++);
            ListUtils.checkConsistency(newList, nextElement);
            newList.add(nextElement);
        }
    }

    private static <K extends Comparable<K>> void checkConsistency(List<K> newList, K nextElement) {
        if (!newList.isEmpty()) {
            Comparable lastElement = (Comparable)newList.get(newList.size() - 1);
            Preconditions.checkArgument((nextElement.compareTo((Comparable)lastElement) >= 0 ? 1 : 0) != 0, (Object)"lists are not sorted, last element is not <= the current element");
        }
    }

    public static <K extends Comparable<K>> List<K> mergeSort(List<K> list) {
        if (list.size() <= 1) {
            return list;
        }
        int half = list.size() / 2;
        List<K> left = ListUtils.mergeSort(list.subList(0, half));
        List<K> right = ListUtils.mergeSort(list.subList(half, list.size()));
        return ListUtils.merge(left, right);
    }
}

