/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import de.jungblut.datastructure.DistanceResult;
import de.jungblut.distance.DistanceMeasurer;
import de.jungblut.distance.VectorDocumentDistanceMeasurer;
import de.jungblut.jrpt.LimitedPriorityQueue;
import de.jungblut.math.DoubleVector;
import de.jungblut.nlp.SparseVectorDocumentMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class InvertedIndex<DOCUMENT_TYPE, KEY_TYPE> {
    private final HashMultimap<KEY_TYPE, Integer> index = HashMultimap.create();
    private final DocumentMapper<DOCUMENT_TYPE, KEY_TYPE> docMapper;
    private final DocumentDistanceMeasurer<DOCUMENT_TYPE, KEY_TYPE> docMeasurer;
    private List<DOCUMENT_TYPE> documents;
    private List<Set<KEY_TYPE>> keys;

    private InvertedIndex(DocumentMapper<DOCUMENT_TYPE, KEY_TYPE> mapper, DocumentDistanceMeasurer<DOCUMENT_TYPE, KEY_TYPE> measurer) {
        this.docMapper = mapper;
        this.docMeasurer = measurer;
    }

    public void build(List<DOCUMENT_TYPE> items) {
        Preconditions.checkNotNull(items, (Object)"Documents should not be NULL!");
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0, (Object)"Documents should contain at least a single item!");
        this.documents = Collections.unmodifiableList(new ArrayList<DOCUMENT_TYPE>(items));
        this.keys = new ArrayList<Set<KEY_TYPE>>(items.size());
        for (int i = 0; i < this.documents.size(); ++i) {
            DOCUMENT_TYPE doc = this.documents.get(i);
            Set<KEY_TYPE> keySet = this.docMapper.mapDocument(doc);
            this.keys.add(keySet);
            for (KEY_TYPE key : keySet) {
                this.index.put(key, (Object)i);
            }
        }
    }

    public List<DistanceResult<DOCUMENT_TYPE>> query(DOCUMENT_TYPE document) {
        return this.query(document, Integer.MAX_VALUE, Double.MAX_VALUE);
    }

    public List<DistanceResult<DOCUMENT_TYPE>> query(DOCUMENT_TYPE document, double minDistance) {
        return this.query(document, Integer.MAX_VALUE, minDistance);
    }

    public List<DistanceResult<DOCUMENT_TYPE>> query(DOCUMENT_TYPE document, int maxResults, double minDistance) {
        Preconditions.checkNotNull(document, (Object)"Document should not be NULL!");
        Preconditions.checkArgument((maxResults > 0 ? 1 : 0) != 0, (Object)("Maximum number of results must be positive and greater than zero! Given: " + maxResults));
        Preconditions.checkArgument((minDistance >= 0.0 && minDistance <= Double.MAX_VALUE ? 1 : 0) != 0, (Object)("Minimum Distance must be between 0d and Double.MAX_VALUE (both inclusive). Given: " + minDistance));
        Set<KEY_TYPE> keys = this.docMapper.mapDocument(document);
        HashSet allSet = new HashSet();
        for (Object key : keys) {
            Set set = this.index.get(key);
            if (set == null || set.isEmpty()) continue;
            allSet.addAll(set);
        }
        LimitedPriorityQueue queue = new LimitedPriorityQueue(maxResults);
        for (Integer docIndex : allSet) {
            Set<KEY_TYPE> candidateKeys;
            DOCUMENT_TYPE candidateDoc = this.documents.get(docIndex);
            double distance = this.docMeasurer.measure(document, keys, candidateDoc, candidateKeys = this.keys.get(docIndex));
            if (!(distance <= minDistance)) continue;
            queue.add(new DistanceResult<DOCUMENT_TYPE>(distance, candidateDoc), distance);
        }
        ArrayList<DistanceResult<DOCUMENT_TYPE>> res = new ArrayList<DistanceResult<DOCUMENT_TYPE>>(queue.size());
        DistanceResult distRes = null;
        while ((distRes = (DistanceResult)queue.poll()) != null) {
            res.add(distRes);
        }
        Collections.reverse(res);
        return res;
    }

    public static <KEY_TYPE, DOCUMENT_TYPE> InvertedIndex<DOCUMENT_TYPE, KEY_TYPE> create(DocumentMapper<DOCUMENT_TYPE, KEY_TYPE> mapper, DocumentDistanceMeasurer<DOCUMENT_TYPE, KEY_TYPE> measurer) {
        return new InvertedIndex<DOCUMENT_TYPE, KEY_TYPE>(mapper, measurer);
    }

    public static InvertedIndex<DoubleVector, Integer> createVectorIndex(DistanceMeasurer measurer) {
        SparseVectorDocumentMapper mapper = new SparseVectorDocumentMapper();
        VectorDocumentDistanceMeasurer meas = VectorDocumentDistanceMeasurer.with(measurer);
        return new InvertedIndex<DoubleVector, Integer>(mapper, meas);
    }

    public static interface DocumentMapper<DOCUMENT_TYPE, KEY_TYPE> {
        public Set<KEY_TYPE> mapDocument(DOCUMENT_TYPE var1);
    }

    public static interface DocumentDistanceMeasurer<DOCUMENT_TYPE, KEY_TYPE> {
        public double measure(DOCUMENT_TYPE var1, Set<KEY_TYPE> var2, DOCUMENT_TYPE var3, Set<KEY_TYPE> var4);
    }
}

