/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import de.jungblut.math.sparse.SparseBitVector;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;

public final class HuffmanTree<VALUE> {
    private final HuffmanTreeNode root = new HuffmanTreeNode();
    private int cardinality;
    private boolean constructed;

    public void addAll(Multiset<VALUE> multiSet) {
        HuffmanTreeNode leftLeaf;
        HuffmanTreeNode rightLeaf;
        Preconditions.checkState((!this.constructed ? 1 : 0) != 0, (Object)"You can only bulk insert into a fresh huffman tree!");
        Preconditions.checkArgument((multiSet.size() > 1 ? 1 : 0) != 0, (Object)"The Multiset should at least contain two items!");
        PriorityQueue<HuffmanTreeNodeEntry> queue = new PriorityQueue<HuffmanTreeNodeEntry>();
        for (Multiset.Entry entry : multiSet.entrySet()) {
            queue.add(new HuffmanTreeNodeEntry(entry.getElement(), entry.getCount()));
        }
        do {
            HuffmanTreeNode parent;
            HuffmanTreeNodeEntry second = (HuffmanTreeNodeEntry)queue.poll();
            rightLeaf = second.node;
            if (second.element != null) {
                rightLeaf = new HuffmanTreeNode();
                rightLeaf.value = second.element;
            }
            HuffmanTreeNodeEntry first = (HuffmanTreeNodeEntry)queue.poll();
            leftLeaf = first.node;
            if (first.element != null) {
                leftLeaf = new HuffmanTreeNode();
                leftLeaf.value = first.element;
            }
            leftLeaf.parent = parent = new HuffmanTreeNode();
            parent.left = leftLeaf;
            rightLeaf.parent = parent;
            parent.right = rightLeaf;
            ++this.cardinality;
            HuffmanTreeNodeEntry sumEntry = new HuffmanTreeNodeEntry(parent, first.getCount() + second.getCount());
            queue.add(sumEntry);
        } while (queue.size() != 1);
        leftLeaf.parent = this.root;
        rightLeaf.parent = this.root;
        this.root.left = leftLeaf;
        this.root.right = rightLeaf;
        --this.cardinality;
        this.constructed = true;
    }

    public Map<VALUE, SparseBitVector> getHuffmanCodes() {
        HashMap map = new HashMap();
        this.traverse(this.root, new BitSet(this.getCardinality()), 0, map);
        return map;
    }

    public VALUE decode(SparseBitVector vector) {
        HuffmanTreeNode current = this.root;
        for (int index = 0; index < vector.getDimension(); ++index) {
            current = (int)vector.get(index) != 0 ? current.right : current.left;
            if (current == null) {
                return null;
            }
            if (current.isLeaf()) break;
        }
        return current.value;
    }

    private void traverse(HuffmanTreeNode node, BitSet currentBits, int currentIndex, Map<VALUE, SparseBitVector> map) {
        BitSet clone;
        if (node.isLeaf()) {
            SparseBitVector bitVector = new SparseBitVector(this.getCardinality());
            int i = currentBits.nextSetBit(0);
            while (i >= 0) {
                bitVector.set(i, 1.0);
                i = currentBits.nextSetBit(i + 1);
            }
            map.put(node.value, bitVector);
        }
        if (node.left != null) {
            clone = (BitSet)currentBits.clone();
            this.traverse(node.left, clone, currentIndex + 1, map);
        }
        if (node.right != null) {
            clone = (BitSet)currentBits.clone();
            clone.set(currentIndex);
            this.traverse(node.right, clone, currentIndex + 1, map);
        }
    }

    public int getCardinality() {
        return this.cardinality;
    }

    class HuffmanTreeNodeEntry
    implements Comparable<HuffmanTreeNodeEntry> {
        final HuffmanTreeNode node;
        final VALUE element;
        final int count;

        HuffmanTreeNodeEntry(HuffmanTreeNode element, int count) {
            this.node = element;
            this.count = count;
            this.element = null;
        }

        HuffmanTreeNodeEntry(VALUE element, int count) {
            this.element = element;
            this.count = count;
            this.node = null;
        }

        public VALUE getElement() {
            return this.element;
        }

        public HuffmanTreeNode getNode() {
            return this.node;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public int compareTo(HuffmanTreeNodeEntry o) {
            return Integer.compare(this.count, o.count);
        }

        public String toString() {
            return "HuffmanTreeNodeEntry [element=" + this.element + ", count=" + this.count + "]";
        }
    }

    class HuffmanTreeNode {
        VALUE value;
        HuffmanTreeNode parent;
        HuffmanTreeNode left;
        HuffmanTreeNode right;

        HuffmanTreeNode() {
        }

        public boolean isLeaf() {
            return this.left == null && this.right == null;
        }
    }
}

