/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import de.jungblut.datastructure.AsyncBufferedOutputStream;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import org.apache.hadoop.io.Writable;

public final class DiskList<E extends Writable>
extends AbstractList<E>
implements Iterable<E>,
AutoCloseable,
Closeable {
    private final String path;
    private State currentState = State.WRITE;
    private DataOutputStream outStream;
    private DataInputStream inStream;
    private long size;
    private E reusableElement;

    public DiskList(String path) throws IOException {
        this(path, 8192);
    }

    public DiskList(String path, int bufferSize) throws IOException {
        this.path = path;
        this.outStream = new DataOutputStream(new AsyncBufferedOutputStream(new FileOutputStream(path), bufferSize));
    }

    public DiskList(String path, E reusableElement) throws IOException {
        this(path);
        this.reusableElement = reusableElement;
    }

    public DiskList(String path, int bufferSize, E reusableElement) throws IOException {
        this(path, bufferSize);
        this.reusableElement = reusableElement;
    }

    @Override
    public boolean add(E element) {
        try {
            element.write((DataOutput)this.outStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        ++this.size;
        return true;
    }

    public void openRead() throws IOException {
        this.closeWrite();
        this.currentState = State.READ;
        this.inStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.path)));
    }

    public E poll(E element) throws IOException {
        element.readFields((DataInput)this.inStream);
        return element;
    }

    private void closeWrite() throws IOException {
        if (this.outStream != null) {
            this.outStream.close();
            this.outStream = null;
        }
    }

    private void closeRead() throws IOException {
        if (this.inStream != null) {
            this.inStream.close();
            this.inStream = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.closeRead();
        this.closeWrite();
        new File(this.path).delete();
    }

    public State getCurrentState() {
        return this.currentState;
    }

    @Override
    public int size() {
        return (int)this.size;
    }

    @Override
    public Iterator<E> iterator() {
        Preconditions.checkNotNull(this.reusableElement, (Object)"You have to provide a reusable element in your constructor to make use of the iterator!");
        if (this.getCurrentState() == State.READ) {
            this.currentState = State.ITERATING;
        } else if (this.getCurrentState() == State.WRITE) {
            try {
                this.openRead();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            this.currentState = State.ITERATING;
        } else {
            throw new IllegalArgumentException("Can not iterate while in state: " + this.getCurrentState());
        }
        return new AbstractIterator<E>(){
            long toRead;
            {
                this.toRead = DiskList.this.size;
            }

            protected E computeNext() {
                try {
                    if (this.toRead > 0L) {
                        --this.toRead;
                        return DiskList.this.poll(DiskList.this.reusableElement);
                    }
                    return (Writable)this.endOfData();
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
        };
    }

    @Override
    public E get(int index) {
        throw new UnsupportedOperationException("Random access is not implemented!");
    }

    public static class IORuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 5448706404076488584L;

        public IORuntimeException() {
        }

        public IORuntimeException(Throwable e) {
            super(e);
        }
    }

    static enum State {
        READ,
        WRITE,
        ITERATING;

    }
}

