/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;

public final class AsyncBufferedOutputStream
extends FilterOutputStream {
    private final FlushThread flusher = new FlushThread();
    private final Thread flusherThread = new Thread((Runnable)this.flusher, "FlushThread");
    private final ArrayBlockingQueue<byte[]> buffers;
    private final byte[] buf;
    private int count = 0;

    public AsyncBufferedOutputStream(OutputStream out) {
        this(out, 8192, 5);
    }

    public AsyncBufferedOutputStream(OutputStream out, int bufSize) {
        this(out, bufSize, 5);
    }

    public AsyncBufferedOutputStream(OutputStream out, int bufSize, int maxBuffers) {
        super(out);
        this.buffers = new ArrayBlockingQueue(maxBuffers);
        this.buf = new byte[bufSize];
        this.flusherThread.start();
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.flushBufferIfSizeLimitReached();
        this.throwOnFlusherError();
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int bytesToWrite;
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int bytesWritten = 0; bytesWritten < len; bytesWritten += bytesToWrite) {
            this.throwOnFlusherError();
            this.flushBufferIfSizeLimitReached();
            bytesToWrite = Math.min(len - bytesWritten, this.buf.length - this.count);
            System.arraycopy(b, off + bytesWritten, this.buf, this.count, bytesToWrite);
            this.count += bytesToWrite;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.forceFlush();
    }

    private void flushBufferIfSizeLimitReached() throws IOException {
        if (this.count >= this.buf.length) {
            this.forceFlush();
        }
    }

    private void forceFlush() throws IOException {
        if (this.count > 0) {
            byte[] copy = new byte[this.count];
            System.arraycopy(this.buf, 0, copy, 0, copy.length);
            try {
                this.buffers.put(copy);
            }
            catch (InterruptedException e) {
                throw new IOException("interrupted flush", e);
            }
            this.count = 0;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.throwOnFlusherError();
        this.forceFlush();
        this.flusher.closed = true;
        try {
            this.flusherThread.interrupt();
            this.flusherThread.join();
            this.throwOnFlusherError();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.out.close();
        }
    }

    private void throwOnFlusherError() throws IOException {
        if (this.flusher != null && this.flusher.errorHappened) {
            throw new IOException("caught flusher to fail writing asynchronously!", this.flusher.caughtException);
        }
    }

    class FlushThread
    implements Runnable {
        volatile boolean closed = false;
        volatile boolean errorHappened = false;
        volatile Exception caughtException;

        FlushThread() {
        }

        @Override
        public void run() {
            try {
                while (!this.closed) {
                    byte[] take = AsyncBufferedOutputStream.this.buffers.take();
                    AsyncBufferedOutputStream.this.out.write(take);
                }
            }
            catch (InterruptedException take) {
            }
            catch (Exception e) {
                this.caughtException = e;
                this.errorHappened = true;
                return;
            }
            try {
                for (byte[] buf : AsyncBufferedOutputStream.this.buffers) {
                    AsyncBufferedOutputStream.this.out.write(buf);
                }
            }
            catch (Exception e) {
                this.caughtException = e;
                this.errorHappened = true;
            }
        }
    }
}

