/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import com.google.common.base.Preconditions;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public final class ArrayUtils {
    private ArrayUtils() {
        throw new IllegalAccessError();
    }

    public static <T> int find(T[] array, T key) {
        Preconditions.checkNotNull(key);
        int position = -1;
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(key)) continue;
            position = i;
            break;
        }
        return position;
    }

    public static int find(int[] array, int key) {
        Preconditions.checkNotNull((Object)key);
        int position = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != key) continue;
            position = i;
            break;
        }
        return position;
    }

    public static int find(long[] array, long key) {
        Preconditions.checkNotNull((Object)key);
        int position = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != key) continue;
            position = i;
            break;
        }
        return position;
    }

    public static int[] concat(int[] ... arrays) {
        int length = 0;
        for (int[] array1 : arrays) {
            length += array1.length;
        }
        int[] merged = new int[length];
        int index = 0;
        for (int[] array : arrays) {
            System.arraycopy(array, 0, merged, index, array.length);
            index += array.length;
        }
        return merged;
    }

    public static long[] concat(long[] ... arrays) {
        int length = 0;
        for (long[] array1 : arrays) {
            length += array1.length;
        }
        long[] merged = new long[length];
        int index = 0;
        for (long[] array : arrays) {
            System.arraycopy(array, 0, merged, index, array.length);
            index += array.length;
        }
        return merged;
    }

    public static double[] concat(double[] ... arrays) {
        int length = 0;
        for (double[] array1 : arrays) {
            length += array1.length;
        }
        double[] merged = new double[length];
        int index = 0;
        for (double[] array : arrays) {
            System.arraycopy(array, 0, merged, index, array.length);
            index += array.length;
        }
        return merged;
    }

    public static <T> T[] concat(T[] ... arrays) {
        if (arrays.length > 0) {
            int length = 0;
            for (T[] array1 : arrays) {
                length += array1.length;
            }
            Object[] merged = (Object[])Array.newInstance(arrays[0].getClass().getComponentType(), length);
            int index = 0;
            for (T[] array : arrays) {
                System.arraycopy(array, 0, merged, index, array.length);
                index += array.length;
            }
            return merged;
        }
        return null;
    }

    public static int[] copy(int[] array) {
        int[] newInt = new int[array.length];
        System.arraycopy(array, 0, newInt, 0, array.length);
        return newInt;
    }

    public static double[] copy(double[] array) {
        double[] newInt = new double[array.length];
        System.arraycopy(array, 0, newInt, 0, array.length);
        return newInt;
    }

    public static long[] copy(long[] array) {
        long[] newInt = new long[array.length];
        System.arraycopy(array, 0, newInt, 0, array.length);
        return newInt;
    }

    public static <T> T[] copy(T[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static void swap(int[] array, int x, int y) {
        int tmpIndex = array[x];
        array[x] = array[y];
        array[y] = tmpIndex;
    }

    public static void swap(long[] array, int x, int y) {
        long tmpIndex = array[x];
        array[x] = array[y];
        array[y] = tmpIndex;
    }

    public static void swap(double[] array, int x, int y) {
        double tmpIndex = array[x];
        array[x] = array[y];
        array[y] = tmpIndex;
    }

    public static void swap(boolean[] array, int x, int y) {
        boolean tmpIndex = array[x];
        array[x] = array[y];
        array[y] = tmpIndex;
    }

    public static <T> void swap(T[] array, int x, int y) {
        T tmpIndex = array[x];
        array[x] = array[y];
        array[y] = tmpIndex;
    }

    public static int[] toPrimitiveArray(List<Integer> list) {
        int[] arr = new int[list.size()];
        int index = 0;
        for (Integer i : list) {
            Preconditions.checkNotNull((Object)i);
            arr[index++] = i;
        }
        return arr;
    }

    public static int[] toPrimitiveArray(Integer[] array) {
        int[] arr = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            Preconditions.checkNotNull((Object)array[i]);
            arr[i] = array[i];
        }
        return arr;
    }

    public static long[] toPrimitiveArray(Long[] array) {
        long[] arr = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            Preconditions.checkNotNull((Object)array[i]);
            arr[i] = array[i];
        }
        return arr;
    }

    public static double[] toPrimitiveArray(Double[] array) {
        double[] arr = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            Preconditions.checkNotNull((Object)array[i]);
            arr[i] = array[i];
        }
        return arr;
    }

    public static List<Integer> toObjectList(int[] array) {
        ArrayList<Integer> lst = new ArrayList<Integer>(array.length);
        for (int x : array) {
            lst.add(x);
        }
        return lst;
    }

    public static List<Long> toObjectList(long[] array) {
        ArrayList<Long> lst = new ArrayList<Long>(array.length);
        for (long x : array) {
            lst.add(x);
        }
        return lst;
    }

    public static List<Double> toObjectList(double[] array) {
        ArrayList<Double> lst = new ArrayList<Double>(array.length);
        for (double x : array) {
            lst.add(x);
        }
        return lst;
    }

    public static <T extends Comparable<T>> int partition(T[] array) {
        return ArrayUtils.partition(array, (int)0, (int)array.length);
    }

    public static <T extends Comparable<T>> int partition(T[] array, int start, int end) {
        int ending = end - 1;
        T x = array[ending];
        int i = start - 1;
        for (int j = start; j < ending; ++j) {
            if (array[j].compareTo(x) >= 0) continue;
            ArrayUtils.swap(array, ++i, j);
        }
        ArrayUtils.swap(array, ++i, ending);
        return i;
    }

    public static int partition(int[] array) {
        return ArrayUtils.partition(array, 0, array.length);
    }

    public static int partition(int[] array, int start, int end) {
        int ending = end - 1;
        int x = array[ending];
        int i = start - 1;
        for (int j = start; j < ending; ++j) {
            if (array[j] > x) continue;
            ArrayUtils.swap(array, ++i, j);
        }
        ArrayUtils.swap(array, ++i, ending);
        return i;
    }

    public static int partition(long[] array) {
        return ArrayUtils.partition(array, 0, array.length);
    }

    public static int partition(long[] array, int start, int end) {
        int ending = end - 1;
        long x = array[ending];
        int i = start - 1;
        for (int j = start; j < ending; ++j) {
            if (array[j] > x) continue;
            ArrayUtils.swap(array, ++i, j);
        }
        ArrayUtils.swap(array, ++i, ending);
        return i;
    }

    public static int partition(double[] array) {
        return ArrayUtils.partition(array, 0, array.length);
    }

    public static int partition(double[] array, int start, int end) {
        int ending = end - 1;
        double x = array[ending];
        int i = start - 1;
        for (int j = start; j < ending; ++j) {
            if (!(array[j] <= x)) continue;
            ArrayUtils.swap(array, ++i, j);
        }
        ArrayUtils.swap(array, ++i, ending);
        return i;
    }

    public static int quickSelect(int[] array, int k) {
        Preconditions.checkArgument((k > 0 && k <= array.length ? 1 : 0) != 0);
        int n = array.length;
        if (n <= 10) {
            ArrayUtils.radixSort(array);
            return k - 1;
        }
        return ArrayUtils.quickSelect(array, 0, n, k);
    }

    public static int quickSelect(int[] array, int start, int end, int k) {
        if (start == end) {
            return start;
        }
        int pivot = ArrayUtils.partition(array, start, end);
        int length = pivot - start + 1;
        if (length == k) {
            return pivot;
        }
        if (k < length) {
            return ArrayUtils.quickSelect(array, start, pivot - 1, k);
        }
        return ArrayUtils.quickSelect(array, pivot + 1, end, k - length);
    }

    public static int quickSelect(double[] array, int k) {
        Preconditions.checkArgument((k > 0 && k <= array.length ? 1 : 0) != 0);
        return ArrayUtils.quickSelect(array, 0, array.length, k);
    }

    public static int quickSelect(double[] array, int start, int end, int k) {
        if (start == end) {
            return start;
        }
        int pivot = ArrayUtils.partition(array, start, end);
        int length = pivot - start + 1;
        if (length == k) {
            return pivot;
        }
        if (k < length) {
            return ArrayUtils.quickSelect(array, start, pivot - 1, k);
        }
        return ArrayUtils.quickSelect(array, pivot + 1, end, k - length);
    }

    public static int quickSelect(long[] array, int k) {
        Preconditions.checkArgument((k > 0 && k <= array.length ? 1 : 0) != 0);
        return ArrayUtils.quickSelect(array, 0, array.length, k);
    }

    public static int quickSelect(long[] array, int start, int end, int k) {
        if (start == end) {
            return start;
        }
        int pivot = ArrayUtils.partition(array, start, end);
        int length = pivot - start + 1;
        if (length == k) {
            return pivot;
        }
        if (k < length) {
            return ArrayUtils.quickSelect(array, start, pivot - 1, k);
        }
        return ArrayUtils.quickSelect(array, pivot + 1, end, k - length);
    }

    public static <T extends Comparable<T>> int quickSelect(T[] array, int k) {
        Preconditions.checkArgument((k > 0 && k <= array.length ? 1 : 0) != 0);
        return ArrayUtils.quickSelect(array, (int)0, (int)array.length, (int)k);
    }

    public static <T extends Comparable<T>> int quickSelect(T[] array, int start, int end, int k) {
        if (start == end) {
            return start;
        }
        int pivot = ArrayUtils.partition(array, (int)start, (int)end);
        int length = pivot - start + 1;
        if (length == k) {
            return pivot;
        }
        if (k < length) {
            return ArrayUtils.quickSelect(array, (int)start, (int)(pivot - 1), (int)k);
        }
        return ArrayUtils.quickSelect(array, (int)(pivot + 1), (int)end, (int)(k - length));
    }

    public static int medianOfMedians(int[] array) {
        int splitSize = array.length / 5;
        if (splitSize <= 2) {
            ArrayUtils.radixSort(array);
            return array[array.length / 2];
        }
        int[] pivots = new int[splitSize];
        for (int i = 0; i < splitSize; ++i) {
            int start = i * 5;
            int end = i * 5 + 5;
            pivots[i] = ArrayUtils.partition(array, start, end);
        }
        return pivots[splitSize / 2];
    }

    public static int[] fromUpTo(int from, int to, int stepsize) {
        int[] v = new int[(to - from) / stepsize];
        for (int i = 0; i < v.length; ++i) {
            v[i] = from + i * stepsize;
        }
        return v;
    }

    public static long[] fromUpTo(long from, long to, long stepsize) {
        long[] v = new long[(int)((to - from) / stepsize)];
        for (int i = 0; i < v.length; ++i) {
            v[i] = from + (long)i * stepsize;
        }
        return v;
    }

    public static double[] fromUpTo(double from, double to, double stepsize) {
        double[] v = new double[(int)Math.round((to - from) / stepsize + 0.5)];
        for (int i = 0; i < v.length; ++i) {
            v[i] = from + (double)i * stepsize;
        }
        return v;
    }

    public static void radixSort(int[] a) {
        int[] nPart = new int[2];
        int[][] part = new int[2][a.length];
        for (int i = 0; i < 32; ++i) {
            nPart[0] = 0;
            nPart[1] = 0;
            for (int anA : a) {
                int n;
                int n2 = n = anA >> i & 1;
                int n3 = nPart[n2];
                nPart[n2] = n3 + 1;
                part[n][n3] = anA;
            }
            System.arraycopy(part[0], 0, a, 0, nPart[0]);
            System.arraycopy(part[1], 0, a, nPart[0], nPart[1]);
        }
    }

    public static void countingSort(int[] a, int low, int high) {
        int[] counts = new int[high - low + 1];
        for (int x : a) {
            int n = x - low;
            counts[n] = counts[n] + 1;
        }
        int current = 0;
        for (int i = 0; i < counts.length; ++i) {
            Arrays.fill(a, current, current + counts[i], i + low);
            current += counts[i];
        }
    }

    public static void quickSort(int[] a) {
        ArrayUtils.quickSort(a, 0, a.length);
    }

    public static void quickSort(int[] a, int offset, int length) {
        if (offset < length) {
            int pivot = ArrayUtils.partition(a, offset, length);
            ArrayUtils.quickSort(a, offset, pivot);
            ArrayUtils.quickSort(a, pivot + 1, length);
        }
    }

    public static void quickSort(long[] a) {
        ArrayUtils.quickSort(a, 0, a.length);
    }

    public static void quickSort(long[] a, int offset, int length) {
        if (offset < length) {
            int pivot = ArrayUtils.partition(a, offset, length);
            ArrayUtils.quickSort(a, offset, pivot);
            ArrayUtils.quickSort(a, pivot + 1, length);
        }
    }

    public static void quickSort(double[] a) {
        ArrayUtils.quickSort(a, 0, a.length);
    }

    public static void quickSort(double[] a, int offset, int length) {
        if (offset < length) {
            int pivot = ArrayUtils.partition(a, offset, length);
            ArrayUtils.quickSort(a, offset, pivot);
            ArrayUtils.quickSort(a, pivot + 1, length);
        }
    }

    public static <T extends Comparable<T>> void quickSort(T[] a) {
        ArrayUtils.quickSort(a, (int)0, (int)a.length);
    }

    public static <T extends Comparable<T>> void quickSort(T[] a, int offset, int length) {
        if (offset < length) {
            int pivot = ArrayUtils.partition(a, (int)offset, (int)length);
            ArrayUtils.quickSort(a, (int)offset, (int)pivot);
            ArrayUtils.quickSort(a, (int)(pivot + 1), (int)length);
        }
    }

    public static void multiQuickSort(int[] ... arrays) {
        ArrayUtils.multiQuickSort(0, arrays);
    }

    public static void multiQuickSort(int sortDimension, int[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            return;
        }
        if (arrays.length == 1) {
            Arrays.sort(arrays[0]);
            return;
        }
        if (sortDimension < 0 || sortDimension >= arrays.length) {
            return;
        }
        int firstArrayLength = arrays[0].length;
        for (int i = 1; i < arrays.length; ++i) {
            if (arrays[i] != null && firstArrayLength == arrays[i].length) continue;
            return;
        }
        ArrayUtils.multiQuickSort(arrays, 0, firstArrayLength, sortDimension);
    }

    private static void multiQuickSort(int[][] a, int offset, int length, int indexToSort) {
        if (offset < length) {
            int pivot = ArrayUtils.multiPartition(a, offset, length, indexToSort);
            ArrayUtils.multiQuickSort(a, offset, pivot, indexToSort);
            ArrayUtils.multiQuickSort(a, pivot + 1, length, indexToSort);
        }
    }

    private static int multiPartition(int[][] array, int start, int end, int partitionArrayIndex) {
        int ending = end - 1;
        int x = array[partitionArrayIndex][ending];
        int i = start - 1;
        for (int j = start; j < ending; ++j) {
            if (array[partitionArrayIndex][j] > x) continue;
            ++i;
            int[][] nArray = array;
            int n = nArray.length;
            for (int k = 0; k < n; ++k) {
                int[] anArray = nArray[k];
                ArrayUtils.swap(anArray, i, j);
            }
        }
        ++i;
        for (int[] anArray : array) {
            ArrayUtils.swap(anArray, i, ending);
        }
        return i;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> void multiQuickSort(T[] ... arrays) {
        ArrayUtils.multiQuickSort((int)0, arrays);
    }

    @SafeVarargs
    public static <T extends Comparable<T>> void multiQuickSort(int sortDimension, T[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            return;
        }
        if (arrays.length == 1) {
            Arrays.sort(arrays[0]);
            return;
        }
        if (sortDimension < 0 || sortDimension >= arrays.length) {
            return;
        }
        int firstArrayLength = arrays[0].length;
        for (int i = 1; i < arrays.length; ++i) {
            if (arrays[i] != null && firstArrayLength == arrays[i].length) continue;
            return;
        }
        ArrayUtils.multiQuickSort(arrays, (int)0, (int)firstArrayLength, (int)sortDimension);
    }

    private static <T extends Comparable<T>> void multiQuickSort(T[][] a, int offset, int length, int indexToSort) {
        if (offset < length) {
            int pivot = ArrayUtils.multiPartition(a, (int)offset, (int)length, (int)indexToSort);
            ArrayUtils.multiQuickSort(a, (int)offset, (int)pivot, (int)indexToSort);
            ArrayUtils.multiQuickSort(a, (int)(pivot + 1), (int)length, (int)indexToSort);
        }
    }

    private static <T extends Comparable<T>> int multiPartition(T[][] array, int start, int end, int partitionArrayIndex) {
        int ending = end - 1;
        T x = array[partitionArrayIndex][ending];
        int i = start - 1;
        for (int j = start; j < ending; ++j) {
            if (array[partitionArrayIndex][j].compareTo(x) >= 0) continue;
            ++i;
            T[][] TArray = array;
            int n = TArray.length;
            for (int k = 0; k < n; ++k) {
                T[] anArray = TArray[k];
                ArrayUtils.swap(anArray, i, j);
            }
        }
        ++i;
        for (T[] anArray : array) {
            ArrayUtils.swap(anArray, i, ending);
        }
        return i;
    }

    public static int[] deduplicate(int[] arr) {
        if (arr.length <= 1) {
            return arr;
        }
        TIntArrayList list = new TIntArrayList();
        TIntHashSet set = new TIntHashSet();
        for (int a : arr) {
            if (!set.add(a)) continue;
            list.add(a);
        }
        return list.toArray();
    }

    public static <T> ArrayList<T> deduplicate(T[] arr) {
        ArrayList<T> list = new ArrayList<T>();
        HashSet<T> set = new HashSet<T>();
        for (T a : arr) {
            if (!set.add(a)) continue;
            list.add(a);
        }
        return list;
    }

    public static int[] union(int[] a, int[] b) {
        TIntHashSet set = new TIntHashSet();
        set.addAll(a);
        set.addAll(b);
        return set.toArray();
    }

    public static int[] intersection(int[] arr, int[] arr2) {
        TIntArrayList lst = new TIntArrayList();
        int i = 0;
        int j = 0;
        while (i < arr.length && j < arr2.length) {
            if (arr[i] == arr2[j]) {
                if (lst.isEmpty() || lst.get(lst.size() - 1) < arr[i]) {
                    lst.add(arr[i]);
                }
                ++i;
                ++j;
                continue;
            }
            if (arr[i] > arr2[j]) {
                ++j;
                continue;
            }
            ++i;
        }
        return lst.toArray();
    }

    public static int[] intersectionUnsorted(int[] arr, int[] arr2) {
        TIntHashSet set = new TIntHashSet();
        TIntHashSet toReturn = new TIntHashSet();
        for (int a : arr) {
            set.add(a);
        }
        for (int a : arr2) {
            if (!set.contains(a)) continue;
            toReturn.add(a);
        }
        return toReturn.toArray();
    }

    public static int missingNumber(int[] array) {
        int sum = 0;
        for (int x : array) {
            sum += x;
        }
        return array.length * (array.length + 1) / 2 - sum;
    }

    public static int min(int[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"array must not be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array must not be empty");
        int minValue = array[0];
        for (int aVector : array) {
            if (minValue <= aVector) continue;
            minValue = aVector;
        }
        return minValue;
    }

    public static int minIndex(int[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"array must not be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array must not be empty");
        int minIndex = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[minIndex] <= array[i]) continue;
            minIndex = i;
        }
        return minIndex;
    }

    public static long min(long[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"array must not be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array must not be empty");
        long minValue = array[0];
        for (long aVector : array) {
            if (minValue <= aVector) continue;
            minValue = aVector;
        }
        return minValue;
    }

    public static int minIndex(long[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"array must not be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array must not be empty");
        int minIndex = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[minIndex] <= array[i]) continue;
            minIndex = i;
        }
        return minIndex;
    }

    public static double min(double[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"array must not be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array must not be empty");
        double minValue = array[0];
        for (double aVector : array) {
            if (!(minValue > aVector)) continue;
            minValue = aVector;
        }
        return minValue;
    }

    public static int minIndex(double[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"array must not be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array must not be empty");
        int minIndex = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[minIndex] > array[i])) continue;
            minIndex = i;
        }
        return minIndex;
    }

    public static int max(int[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"array must not be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array must not be empty");
        int maxValue = array[0];
        for (int aVector : array) {
            if (maxValue >= aVector) continue;
            maxValue = aVector;
        }
        return maxValue;
    }

    public static int maxIndex(int[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"array must not be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array must not be empty");
        int maxIndex = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[maxIndex] >= array[i]) continue;
            maxIndex = i;
        }
        return maxIndex;
    }

    public static long max(long[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"array must not be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array must not be empty");
        long maxValue = array[0];
        for (long aVector : array) {
            if (maxValue >= aVector) continue;
            maxValue = aVector;
        }
        return maxValue;
    }

    public static int maxIndex(long[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"array must not be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array must not be empty");
        int maxIndex = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[maxIndex] >= array[i]) continue;
            maxIndex = i;
        }
        return maxIndex;
    }

    public static double max(double[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"array must not be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array must not be empty");
        double maxValue = array[0];
        for (double aVector : array) {
            if (!(maxValue < aVector)) continue;
            maxValue = aVector;
        }
        return maxValue;
    }

    public static int maxIndex(double[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"array must not be null");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array must not be empty");
        int maxIndex = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[maxIndex] < array[i])) continue;
            maxIndex = i;
        }
        return maxIndex;
    }

    public static <T> T[] subArray(T[] array, int splitIndex) {
        return ArrayUtils.subArray(array, 0, splitIndex);
    }

    public static <T> T[] subArray(T[] array, int startIndex, int splitIndex) {
        Object[] subArray = (Object[])Array.newInstance(array.getClass().getComponentType(), splitIndex - startIndex + 1);
        System.arraycopy(array, startIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static <T> T[] shuffle(T[] array) {
        return ArrayUtils.shuffle(array, new Random());
    }

    public static <T> T[] shuffle(T[] array, Random rnd) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, rnd.nextInt(i));
        }
        return array;
    }

    @SafeVarargs
    public static <T> T[] multiShuffle(T[] array, T[] ... additions) {
        return ArrayUtils.multiShuffle(array, new Random(), additions);
    }

    @SafeVarargs
    public static <T> T[] multiShuffle(T[] array, Random rnd, T[] ... additions) {
        for (int i = array.length; i > 1; --i) {
            int swapIndex = rnd.nextInt(i);
            ArrayUtils.swap(array, i - 1, swapIndex);
            for (T[] arr : additions) {
                ArrayUtils.swap(arr, i - 1, swapIndex);
            }
        }
        return array;
    }

    public static int[] create(int ... arrays) {
        return arrays;
    }

    public static long[] create(long ... arrays) {
        return arrays;
    }

    public static double[] create(double ... arrays) {
        return arrays;
    }

    public static byte[] create(byte ... arrays) {
        return arrays;
    }

    @SafeVarargs
    public static <T> T[] create(T ... arrays) {
        return arrays;
    }

    public static int[] merge(int[] a, int[] b) {
        int[] toReturn = new int[a.length + b.length];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < a.length && j < b.length) {
            if (a[i] < b[j]) {
                toReturn[k] = a[i];
                ++i;
            } else {
                toReturn[k] = b[j];
                ++j;
            }
            ++k;
        }
        System.arraycopy(a, i, toReturn, k, a.length - i);
        System.arraycopy(b, j, toReturn, k + a.length - i, b.length - j);
        return toReturn;
    }

    public static void merge(int[] numbers, int startIndexA, int endIndexA, int endIndexB) {
        int[] toReturn = new int[endIndexB - startIndexA + 1];
        int k = startIndexA;
        int j = endIndexA + 1;
        for (int i = 0; i < toReturn.length; ++i) {
            if (numbers[k] < numbers[j]) {
                toReturn[i] = numbers[k];
                ++k;
            } else {
                toReturn[i] = numbers[j];
                ++j;
            }
            if (j <= endIndexB) continue;
            System.arraycopy(numbers, k, toReturn, i, endIndexA - k + 1);
            break;
        }
        System.arraycopy(toReturn, 0, numbers, startIndexA, toReturn.length);
    }

    public static boolean isValidIndex(int[] array, int index) {
        return index >= 0 && index < array.length;
    }

    public static boolean isValidIndex(double[] array, int index) {
        return index >= 0 && index < array.length;
    }

    public static boolean isValidIndex(float[] array, int index) {
        return index >= 0 && index < array.length;
    }

    public static boolean isValidIndex(long[] array, int index) {
        return index >= 0 && index < array.length;
    }

    public static boolean isValidIndex(boolean[] array, int index) {
        return index >= 0 && index < array.length;
    }

    public static boolean isValidIndex(byte[] array, int index) {
        return index >= 0 && index < array.length;
    }

    public static <T> boolean isValidIndex(T[] array, int index) {
        return index >= 0 && index < array.length;
    }
}

