/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.datastructure;

import java.util.Iterator;

public final class ArrayIterator<E>
implements Iterator<E> {
    private final E[] array;
    private int currentIndex = 0;

    public ArrayIterator(E[] array) {
        this.array = array;
    }

    @Override
    public final boolean hasNext() {
        return this.currentIndex < this.array.length;
    }

    @Override
    public final E next() {
        return this.array[this.currentIndex++];
    }

    public final int getIndex() {
        return this.currentIndex - 1;
    }

    @Override
    public final void remove() {
        if (this.currentIndex >= 0 && this.currentIndex <= this.array.length) {
            this.array[this.currentIndex - 1] = null;
        }
    }
}

