/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.crawl;

import de.jungblut.crawl.Crawler;
import de.jungblut.crawl.FetchResult;
import de.jungblut.crawl.FetchResultPersister;
import de.jungblut.crawl.ResultWriter;
import de.jungblut.crawl.extraction.Extractor;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;

public final class SequentialCrawler<T extends FetchResult>
implements Crawler<T> {
    private Extractor<T> extractor;
    private FetchResultPersister<T> persister;
    private Thread persisterThread;
    private int fetches = 100000;

    public SequentialCrawler(int fetches, Extractor<T> extractor, ResultWriter<T> writer) throws IOException {
        this.setup(fetches, extractor, writer);
    }

    @Override
    public final void setup(int fetches, Extractor<T> extractor, ResultWriter<T> writer) throws IOException {
        this.fetches = fetches;
        this.extractor = extractor;
        this.persister = new FetchResultPersister<T>(writer);
        this.persisterThread = new Thread(this.persister);
        this.persisterThread.start();
    }

    @Override
    public final void process(String ... seedUrl) throws InterruptedException, ExecutionException {
        ArrayDeque<String> linksToCrawl = new ArrayDeque<String>();
        HashSet<String> visited = new HashSet<String>();
        linksToCrawl.addAll(Arrays.asList(seedUrl));
        visited.addAll(Arrays.asList(seedUrl));
        while (this.fetches > 0 && !linksToCrawl.isEmpty()) {
            String urlToCrawl = (String)linksToCrawl.poll();
            T extractedResult = this.extractor.extract(urlToCrawl);
            if (extractedResult == null) continue;
            this.persister.add(extractedResult);
            for (String outlink : ((FetchResult)extractedResult).outlinks) {
                if (!visited.add(outlink)) continue;
                linksToCrawl.add(outlink);
            }
            --this.fetches;
        }
        this.persister.stop();
        this.persisterThread.join();
    }
}

