/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.crawl;

import de.jungblut.crawl.FetchResult;
import de.jungblut.crawl.ResultWriter;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class SequenceFileResultWriter<T extends FetchResult>
implements ResultWriter<T> {
    protected SequenceFile.Writer writer;

    @Override
    public void open(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path outputPath = this.getOutputPath();
        fs.delete(outputPath, true);
        this.writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)outputPath), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)});
    }

    @Override
    public void write(FetchResult result) throws IOException {
        this.writer.append((Writable)new Text(result.url), (Writable)SequenceFileResultWriter.asText(result.outlinks));
    }

    public Path getOutputPath() {
        return new Path("files/crawl/result.seq");
    }

    private static Text asText(Set<String> set) {
        Text text = new Text();
        StringBuilder sb = new StringBuilder();
        for (String s : set) {
            sb.append(s);
            sb.append('\t');
        }
        text.set(sb.toString());
        return text;
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

