/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.crawl;

import de.jungblut.crawl.FetchResult;
import de.jungblut.crawl.ResultWriter;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FetchResultPersister<T extends FetchResult>
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(FetchResultPersister.class);
    private volatile boolean running = true;
    private final ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
    private final ResultWriter<T> resWriter;

    public FetchResultPersister(ResultWriter<T> resWriter) throws IOException {
        this(resWriter, new Configuration());
    }

    public FetchResultPersister(ResultWriter<T> resWriter, Configuration conf) throws IOException {
        this.resWriter = resWriter;
        this.resWriter.open(conf);
    }

    public final void add(T result) {
        if (this.running) {
            this.queue.add(result);
        }
    }

    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        FetchResult poll;
        long retrieved = 0L;
        while (this.running) {
            poll = (FetchResult)this.queue.poll();
            if (poll != null) {
                boolean failHappend = false;
                try {
                    this.resWriter.write(poll);
                    if (++retrieved % 100L != 0L) continue;
                    LOG.info("Retrieved " + retrieved + " sites!");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    failHappend = true;
                }
                finally {
                    if (!failHappend) continue;
                    try {
                        this.resWriter.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            while (!this.queue.isEmpty()) {
                poll = (FetchResult)this.queue.poll();
                this.resWriter.write(poll);
                if (++retrieved % 100L != 0L) continue;
                LOG.info("Retrieved " + retrieved + " sites!");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (this.resWriter != null) {
                try {
                    this.resWriter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        LOG.info("Retrieved " + retrieved + " sites in total!");
    }
}

