/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.clustering;

import de.jungblut.distance.EuclidianDistance;
import de.jungblut.jrpt.KDTree;
import de.jungblut.jrpt.VectorDistanceTuple;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.tuple.Tuple;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class OnePassExclusiveClustering {
    private int minSize;
    private int k;
    private double t1;
    private boolean mergeOverlaps;

    public OnePassExclusiveClustering(double t1) {
        this(t1, Integer.MAX_VALUE, 2, false);
    }

    public OnePassExclusiveClustering(double t1, int k, int minSize, boolean mergeOverlaps) {
        this.t1 = t1;
        this.k = k;
        this.minSize = minSize;
    }

    public List<DoubleVector> cluster(List<DoubleVector> values, boolean verbose) {
        ArrayList<DoubleVector> centers = new ArrayList<DoubleVector>();
        KDTree tree = new KDTree();
        Stream<Tuple> payloadStream = IntStream.range(0, values.size()).mapToObj(i -> new Tuple((Object)((DoubleVector)values.get(i)), (Object)i));
        tree.constructWithPayload(payloadStream);
        tree.balanceBySort();
        BitSet set = new BitSet(values.size());
        int items = 0;
        for (int i2 = 0; i2 < values.size(); ++i2) {
            if (!set.get(i2)) {
                DoubleVector v = values.get(i2);
                DoubleVector center = v.deepCopy();
                List nns = tree.getNearestNeighbours(v, this.k, this.t1);
                int sum = 1;
                for (VectorDistanceTuple nn : nns) {
                    if (!(nn.getDistance() < this.t1) || set.get((Integer)nn.getValue())) continue;
                    ++sum;
                    set.set((Integer)nn.getValue());
                    center = center.add(nn.getVector());
                }
                if (sum >= this.minSize) {
                    DoubleVector newCenter = center.divide((double)sum);
                    if (this.mergeOverlaps) {
                        boolean noOverlap = true;
                        for (int x = 0; x < centers.size(); ++x) {
                            DoubleVector ref = centers.get(x);
                            double dist = EuclidianDistance.get().measureDistance(ref, newCenter);
                            if (!(dist < this.t1)) continue;
                            centers.set(x, ref.add(newCenter).divide(2.0));
                            noOverlap = false;
                            break;
                        }
                        if (noOverlap) {
                            centers.add(newCenter);
                        }
                    } else {
                        centers.add(newCenter);
                    }
                }
                set.set(i2);
            }
            if (!verbose || ++items % 1000 != 0) continue;
            String progressString = NumberFormat.getPercentInstance().format((double)items / (double)tree.size());
            System.out.format("Processed %d/%d = %s. Centers found: %d.\n", items, tree.size(), progressString, centers.size());
        }
        return centers;
    }
}

