/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.clustering;

import de.jungblut.distance.DistanceMeasurer;
import de.jungblut.math.DoubleVector;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class DBSCANClustering {
    public static List<List<DoubleVector>> cluster(List<DoubleVector> points, DistanceMeasurer measurer, int minPoints, double epsilon) {
        ArrayList<List<DoubleVector>> clusterList = new ArrayList<List<DoubleVector>>();
        TIntHashSet visited = new TIntHashSet();
        ArrayList<Object> currentCluster = new ArrayList<DoubleVector>();
        int end = points.size();
        for (int i = 0; i < end; ++i) {
            if (visited.contains(i)) continue;
            visited.add(i);
            TIntArrayList neighbours = DBSCANClustering.getNearestNeighbours(visited, null, points, i, measurer, epsilon);
            if (neighbours.size() <= minPoints) continue;
            currentCluster.add(points.get(i));
            DBSCANClustering.expand(points, measurer, visited, neighbours, currentCluster, epsilon, minPoints);
            clusterList.add(currentCluster);
            currentCluster = new ArrayList();
        }
        return clusterList;
    }

    private static TIntArrayList getNearestNeighbours(TIntHashSet visited, TIntHashSet currentNeighbours, List<DoubleVector> points, int x, DistanceMeasurer measurer, double epsilon) {
        TIntArrayList list = new TIntArrayList();
        DoubleVector ref = points.get(x);
        for (int i = 0; i < points.size(); ++i) {
            double dist;
            if (visited.contains(i) || currentNeighbours != null && currentNeighbours.contains(i) || !((dist = measurer.measureDistance(ref, points.get(i))) < epsilon)) continue;
            list.add(i);
        }
        return list;
    }

    private static void expand(List<DoubleVector> points, DistanceMeasurer measurer, TIntHashSet visited, TIntArrayList neighbours, List<DoubleVector> currentCluster, double epsilon, int minPoints) {
        TIntHashSet currentNeighbours = new TIntHashSet();
        currentNeighbours.addAll((TIntCollection)currentNeighbours);
        for (int i = 0; i < neighbours.size(); ++i) {
            int neighbour = neighbours.get(i);
            if (visited.contains(neighbour)) continue;
            visited.add(neighbour);
            TIntArrayList expandedNeighbours = DBSCANClustering.getNearestNeighbours(visited, currentNeighbours, points, neighbour, measurer, epsilon);
            currentNeighbours.addAll((TIntCollection)expandedNeighbours);
            neighbours.addAll((TIntCollection)expandedNeighbours);
            currentCluster.add(points.get(neighbour));
        }
    }

    public static List<DoubleVector> findNoise(List<DoubleVector> points, List<List<DoubleVector>> clusteringOutput) {
        ArrayList<DoubleVector> noise = new ArrayList<DoubleVector>();
        HashSet<DoubleVector> set = new HashSet<DoubleVector>();
        for (List<DoubleVector> component : clusteringOutput) {
            set.addAll(component);
        }
        for (DoubleVector point : points) {
            if (set.contains(point)) continue;
            noise.add(point);
        }
        return noise;
    }
}

