/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.clustering;

import de.jungblut.datastructure.ArrayUtils;
import de.jungblut.distance.DistanceMeasurer;
import de.jungblut.math.DoubleMatrix;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.dense.DenseDoubleMatrix;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class DBSCAN {
    private List<DoubleVector> noise;
    private ArrayList<DoubleVector>[] connectedComponents;

    public ArrayList<DoubleVector>[] cluster(List<DoubleVector> points, DistanceMeasurer measurer, int minPoints, double epsilon) {
        DoubleMatrix distanceMatrix = this.generateDistanceMatrix(measurer, points);
        TIntObjectHashMap<int[]> adjacencyMatrix = this.generateAdjacencyMatrix(distanceMatrix, points, minPoints, epsilon);
        this.connectedComponents = this.findConnectedComponents(points, adjacencyMatrix);
        this.noise = this.findNoise(points);
        return this.connectedComponents;
    }

    public List<DoubleVector> getNoise() {
        return this.noise;
    }

    private DoubleMatrix generateDistanceMatrix(DistanceMeasurer measurer, List<DoubleVector> pointList) {
        int n = pointList.size();
        DenseDoubleMatrix matrix = new DenseDoubleMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double distance = measurer.measureDistance(pointList.get(i), pointList.get(j));
                matrix.set(i, j, distance);
            }
        }
        return matrix;
    }

    private TIntObjectHashMap<int[]> generateAdjacencyMatrix(DoubleMatrix distanceMatrix, List<DoubleVector> points, int minPoints, double epsilon) {
        TIntObjectHashMap adjacencyList = new TIntObjectHashMap();
        for (int col = 0; col < distanceMatrix.getColumnCount(); ++col) {
            ArrayList<Integer> possibleNeighbours = new ArrayList<Integer>();
            for (int row = 0; row < distanceMatrix.getRowCount(); ++row) {
                double distance;
                if (row == col || !((distance = distanceMatrix.get(row, col)) < epsilon)) continue;
                possibleNeighbours.add(row);
            }
            if (possibleNeighbours.size() < minPoints) continue;
            adjacencyList.put(col, (Object)ArrayUtils.toPrimitiveArray(possibleNeighbours));
        }
        return adjacencyList;
    }

    private ArrayList<DoubleVector>[] findConnectedComponents(List<DoubleVector> points, TIntObjectHashMap<int[]> adjacencyMatrix) {
        TIntObjectHashMap connectedComponents = new TIntObjectHashMap();
        TIntHashSet globallyVisitedVertices = new TIntHashSet();
        int clusterId = 0;
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            if (globallyVisitedVertices.contains(i)) continue;
            globallyVisitedVertices.add(i);
            TIntHashSet set = new TIntHashSet();
            set = this.bfs(set, i, adjacencyMatrix);
            if (set.isEmpty()) continue;
            connectedComponents.put(clusterId++, (Object)set.toArray());
            globallyVisitedVertices.addAll((TIntCollection)set);
        }
        ArrayList[] array = new ArrayList[connectedComponents.size()];
        TIntObjectIterator iterator = connectedComponents.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int[] values = (int[])iterator.value();
            ArrayList<DoubleVector> list = new ArrayList<DoubleVector>(values.length);
            for (int val : values) {
                list.add(points.get(val));
            }
            array[iterator.key()] = list;
        }
        return array;
    }

    private List<DoubleVector> findNoise(List<DoubleVector> points) {
        ArrayList<DoubleVector> noise = new ArrayList<DoubleVector>();
        HashSet<DoubleVector> set = new HashSet<DoubleVector>();
        for (ArrayList<DoubleVector> component : this.connectedComponents) {
            set.addAll(component);
        }
        for (DoubleVector point : points) {
            if (set.contains(point)) continue;
            noise.add(point);
        }
        return noise;
    }

    private TIntHashSet bfs(TIntHashSet set, int start, TIntObjectHashMap<int[]> adjacencyMatrix) {
        ArrayDeque<Integer> vertexDeque = new ArrayDeque<Integer>();
        vertexDeque.add(start);
        while (!vertexDeque.isEmpty()) {
            start = (Integer)vertexDeque.poll();
            int[] is = (int[])adjacencyMatrix.get(start);
            if (is == null) continue;
            set.add(start);
            for (int i : is) {
                if (set.contains(i)) continue;
                set.add(i);
                vertexDeque.add(i);
            }
        }
        return set;
    }
}

