/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.clustering;

import com.google.common.base.Preconditions;
import de.jungblut.distance.DistanceMeasurer;
import de.jungblut.math.DoubleVector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CanopyClustering {
    private static final Logger LOG = LogManager.getLogger(CanopyClustering.class);

    private CanopyClustering() {
        throw new IllegalAccessError();
    }

    public static List<DoubleVector> createCanopies(List<DoubleVector> pPoints, DistanceMeasurer measure, double t1, double t2, boolean verbose) {
        Preconditions.checkArgument((t1 > t2 ? 1 : 0) != 0, (Object)"t1 must be > t2!");
        LinkedList<DoubleVector> points = new LinkedList<DoubleVector>(pPoints);
        ArrayList<DoubleVector> canopyList = new ArrayList<DoubleVector>();
        long start = System.currentTimeMillis();
        while (!points.isEmpty()) {
            DoubleVector p1 = points.get(0);
            points.remove(0);
            DoubleVector canopy = p1.deepCopy();
            int assigned = 1;
            Iterator iterator = points.iterator();
            while (iterator.hasNext()) {
                DoubleVector p2 = (DoubleVector)iterator.next();
                double dist = measure.measureDistance(p1, p2);
                if (dist < t1) {
                    ++assigned;
                    canopy.add(p2);
                }
                if (!(dist < t2)) continue;
                iterator.remove();
            }
            if (assigned > 1) {
                canopy = canopy.divide((double)assigned);
            }
            canopyList.add(canopy);
            if (verbose) {
                LOG.info(points.size() + " vectors remaining to cluster | Found canopies: " + canopyList.size() + " | Took " + (System.currentTimeMillis() - start) + "ms!");
            }
            start = System.currentTimeMillis();
        }
        return canopyList;
    }
}

