/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.clustering;

import de.jungblut.distance.DistanceMeasurer;
import de.jungblut.math.DoubleVector;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AgglomerativeClustering {
    private static final Logger LOG = LogManager.getLogger(AgglomerativeClustering.class);

    public static List<List<ClusterNode>> cluster(List<DoubleVector> points, DistanceMeasurer distanceMeasurer, boolean verbose) {
        return AgglomerativeClustering.cluster(points, distanceMeasurer, Double.MAX_VALUE, verbose);
    }

    static List<List<ClusterNode>> cluster(List<DoubleVector> points, DistanceMeasurer distanceMeasurer, double distanceThreshold, boolean verbose) {
        ArrayList<List<ClusterNode>> levels = new ArrayList<List<ClusterNode>>();
        ArrayList<ClusterNode> currentLevel = new ArrayList<ClusterNode>();
        for (DoubleVector point : points) {
            currentLevel.add(new ClusterNode(point));
        }
        levels.add(currentLevel);
        int iteration = 0;
        while (currentLevel.size() != 1) {
            ArrayList<ClusterNode> nextLevel = new ArrayList<ClusterNode>();
            TIntHashSet excludeIndex = new TIntHashSet();
            for (int i = 0; i < currentLevel.size(); ++i) {
                if (excludeIndex.contains(i)) continue;
                excludeIndex.add(i);
                ClusterNode ci = (ClusterNode)currentLevel.get(i);
                int nearest = -1;
                double nearestDistance = Double.MAX_VALUE;
                for (int j = 0; j < currentLevel.size(); ++j) {
                    if (excludeIndex.contains(j)) continue;
                    ClusterNode cj = (ClusterNode)currentLevel.get(j);
                    double dist = distanceMeasurer.measureDistance(ci.getMean(), cj.getMean());
                    if (!(dist < nearestDistance) || !(dist < distanceThreshold)) continue;
                    nearest = j;
                    nearestDistance = dist;
                }
                if (nearest >= 0) {
                    ClusterNode cn = new ClusterNode(ci, (ClusterNode)currentLevel.get(nearest), nearestDistance);
                    nextLevel.add(cn);
                    excludeIndex.add(nearest);
                    continue;
                }
                nextLevel.add(ci);
            }
            if (verbose) {
                LOG.info(iteration + " | Current level contains " + nextLevel.size() + " elements.");
            }
            levels.add(nextLevel);
            currentLevel = nextLevel;
            ++iteration;
        }
        Collections.reverse(levels);
        return levels;
    }

    public static class ClusterNode {
        private ClusterNode parent;
        private ClusterNode left;
        private ClusterNode right;
        private final DoubleVector mean;
        private double splitDistance;

        ClusterNode(DoubleVector mean) {
            this.mean = mean.deepCopy();
            this.splitDistance = 0.0;
        }

        ClusterNode(ClusterNode node1, ClusterNode node2, double distance) {
            this.mean = node1.mean.add(node2.mean).divide(2.0);
            this.splitDistance = distance;
            this.left = node1;
            this.right = node2;
            this.left.parent = this;
            this.right.parent = this;
        }

        public DoubleVector getMean() {
            return this.mean;
        }

        public double getSplitDistance() {
            return this.splitDistance;
        }

        public ClusterNode getParent() {
            return this.parent;
        }

        public ClusterNode getLeft() {
            return this.left;
        }

        public ClusterNode getRight() {
            return this.right;
        }

        public String toString() {
            return "ClusterNode [mean=" + this.mean + "]";
        }
    }
}

