/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.classification.tree;

import de.jungblut.classification.tree.AbstractTreeNode;
import de.jungblut.math.DoubleVector;
import java.lang.reflect.Method;
import java.util.Random;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public final class TreeCompiler
implements Opcodes {
    private static final String CLAZZ_NAME = "CompiledNode";
    private static final Random RNG = new Random();

    public static AbstractTreeNode compileAndLoad(String name, AbstractTreeNode node) throws Exception {
        return TreeCompiler.load(name, TreeCompiler.compileNode(name, node));
    }

    public static AbstractTreeNode load(String name, byte[] byteCode) throws Exception {
        Class loadClass = TreeCompiler.loadClass(byteCode, name);
        return (AbstractTreeNode)loadClass.newInstance();
    }

    public static byte[] compileNode(String name, AbstractTreeNode root) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(50, 17, name, null, Type.getInternalName(AbstractTreeNode.class), null);
        cw.visitSource(name + ".java", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()" + Type.VOID_TYPE.getDescriptor(), null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(AbstractTreeNode.class), "<init>", "()" + Type.VOID_TYPE.getDescriptor());
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "predict", Type.getMethodDescriptor((Method)AbstractTreeNode.class.getDeclaredMethod("predict", DoubleVector.class)), null, null);
        Label end = new Label();
        root.transformToByteCode(mv, end);
        mv.visitLabel(end);
        mv.visitInsn(Type.INT_TYPE.getOpcode(172));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "transformToByteCode", Type.getMethodDescriptor((Method)AbstractTreeNode.class.getDeclaredMethod("transformToByteCode", MethodVisitor.class, Label.class)), null, null);
        mv.visitTypeInsn(187, "java/lang/UnsupportedOperationException");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/UnsupportedOperationException", "<init>", "()V");
        mv.visitInsn(191);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static synchronized String generateClassName() {
        return "CompiledNode_" + System.currentTimeMillis() + "_" + Integer.toString(Math.abs(RNG.nextInt()), 36);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <CLAZZ> Class<CLAZZ> loadClass(byte[] b, String className) throws Exception {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        Class<?> cls = Class.forName("java.lang.ClassLoader");
        Method method = cls.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        try {
            Class<?> clz = Class.forName(className);
            return clz;
        }
        catch (Exception clz) {
            method.setAccessible(true);
            try {
                Object[] args = new Object[]{className, b, new Integer(0), new Integer(b.length)};
                Class clazz = (Class)method.invoke((Object)loader, args);
                return clazz;
            }
            finally {
                method.setAccessible(false);
            }
        }
    }
}

