/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.classification.tree;

import de.jungblut.classification.tree.AbstractTreeNode;
import de.jungblut.math.DoubleVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableUtils;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class NumericalNode
extends AbstractTreeNode {
    private int splitAttributeIndex;
    private double splitAttributeValue;
    private AbstractTreeNode lower;
    private AbstractTreeNode higher;

    public NumericalNode() {
    }

    public NumericalNode(int splitAttributeIndex, double splitAttributeValue, AbstractTreeNode lower, AbstractTreeNode higher) {
        this.splitAttributeIndex = splitAttributeIndex;
        this.splitAttributeValue = splitAttributeValue;
        this.lower = lower;
        this.higher = higher;
    }

    @Override
    public int predict(DoubleVector features) {
        if (features.get(this.splitAttributeIndex) > this.splitAttributeValue) {
            return this.higher.predict(features);
        }
        return this.lower.predict(features);
    }

    @Override
    public void transformToByteCode(MethodVisitor visitor, Label returnLabel) {
        visitor.visitVarInsn(Type.getType(DoubleVector.class).getOpcode(21), 1);
        visitor.visitLdcInsn((Object)this.splitAttributeIndex);
        visitor.visitMethodInsn(185, Type.getInternalName(DoubleVector.class), "get", "(" + Type.INT_TYPE.getDescriptor() + ")" + Type.DOUBLE_TYPE.getDescriptor());
        visitor.visitLdcInsn((Object)this.splitAttributeValue);
        Label smallerLabel = new Label();
        Label end = new Label();
        visitor.visitInsn(152);
        visitor.visitJumpInsn(158, smallerLabel);
        this.higher.transformToByteCode(visitor, returnLabel);
        visitor.visitJumpInsn(167, end);
        visitor.visitLabel(smallerLabel);
        this.lower.transformToByteCode(visitor, returnLabel);
        visitor.visitLabel(end);
    }

    public void readFields(DataInput in) throws IOException {
        this.splitAttributeIndex = WritableUtils.readVInt((DataInput)in);
        this.splitAttributeValue = in.readDouble();
        this.lower = AbstractTreeNode.read(in);
        this.higher = AbstractTreeNode.read(in);
    }

    @Override
    protected void writeInternal(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.splitAttributeIndex);
        out.writeDouble(this.splitAttributeValue);
        this.lower.write(out);
        this.higher.write(out);
    }

    @Override
    public byte getType() {
        return 2;
    }
}

