/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.classification.tree;

import de.jungblut.classification.tree.AbstractTreeNode;
import de.jungblut.math.DoubleVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.WritableUtils;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class NominalNode
extends AbstractTreeNode {
    private int splitAttributeIndex;
    int[] nominalSplitValues;
    AbstractTreeNode[] children;

    public NominalNode() {
    }

    public NominalNode(int splitAttributeIndex, int numCategories) {
        this.splitAttributeIndex = splitAttributeIndex;
        this.nominalSplitValues = new int[numCategories];
        this.children = new AbstractTreeNode[numCategories];
    }

    public void sortInternal() {
        int i;
        Object[] arr = new SortItem[this.nominalSplitValues.length];
        for (i = 0; i < this.nominalSplitValues.length; ++i) {
            arr[i] = new SortItem(this.nominalSplitValues[i], this.children[i]);
        }
        Arrays.sort(arr);
        for (i = 0; i < this.nominalSplitValues.length; ++i) {
            this.nominalSplitValues[i] = ((SortItem)arr[i]).val;
            this.children[i] = ((SortItem)arr[i]).child;
        }
    }

    @Override
    public int predict(DoubleVector features) {
        int categoricalValue = (int)features.get(this.splitAttributeIndex);
        int foundIndex = Arrays.binarySearch(this.nominalSplitValues, categoricalValue);
        if (foundIndex >= 0) {
            return this.children[foundIndex].predict(features);
        }
        return 0;
    }

    @Override
    public void transformToByteCode(MethodVisitor visitor, Label returnLabel) {
        int i;
        visitor.visitVarInsn(Type.getType(DoubleVector.class).getOpcode(21), 1);
        visitor.visitLdcInsn((Object)this.splitAttributeIndex);
        visitor.visitMethodInsn(185, Type.getInternalName(DoubleVector.class), "get", "(" + Type.INT_TYPE.getDescriptor() + ")" + Type.DOUBLE_TYPE.getDescriptor());
        visitor.visitInsn(142);
        Label end = new Label();
        Label defaultLabel = new Label();
        Label[] labels = new Label[this.nominalSplitValues.length];
        for (i = 0; i < this.nominalSplitValues.length; ++i) {
            labels[i] = new Label();
        }
        visitor.visitLookupSwitchInsn(defaultLabel, this.nominalSplitValues, labels);
        for (i = 0; i < this.nominalSplitValues.length; ++i) {
            visitor.visitLabel(labels[i]);
            this.children[i].transformToByteCode(visitor, returnLabel);
            visitor.visitJumpInsn(167, end);
        }
        visitor.visitLabel(defaultLabel);
        visitor.visitLdcInsn((Object)0);
        visitor.visitLabel(end);
    }

    public void readFields(DataInput in) throws IOException {
        this.splitAttributeIndex = WritableUtils.readVInt((DataInput)in);
        int len = WritableUtils.readVInt((DataInput)in);
        this.children = new AbstractTreeNode[len];
        this.nominalSplitValues = new int[len];
        for (int i = 0; i < len; ++i) {
            this.nominalSplitValues[i] = WritableUtils.readVInt((DataInput)in);
            this.children[i] = AbstractTreeNode.read(in);
        }
    }

    @Override
    protected void writeInternal(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.splitAttributeIndex);
        WritableUtils.writeVInt((DataOutput)out, (int)this.nominalSplitValues.length);
        for (int i = 0; i < this.nominalSplitValues.length; ++i) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.nominalSplitValues[i]);
            this.children[i].write(out);
        }
    }

    @Override
    public byte getType() {
        return 3;
    }

    private class SortItem
    implements Comparable<SortItem> {
        final int val;
        final AbstractTreeNode child;

        public SortItem(int val, AbstractTreeNode child) {
            this.val = val;
            this.child = child;
        }

        @Override
        public int compareTo(SortItem o) {
            return Integer.compare(this.val, o.val);
        }
    }
}

