/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.classification.tree;

import de.jungblut.classification.tree.LeafNode;
import de.jungblut.classification.tree.NominalNode;
import de.jungblut.classification.tree.NumericalNode;
import de.jungblut.math.DoubleVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public abstract class AbstractTreeNode
implements Writable {
    public abstract int predict(DoubleVector var1);

    public abstract void transformToByteCode(MethodVisitor var1, Label var2);

    public abstract byte getType();

    protected abstract void writeInternal(DataOutput var1) throws IOException;

    public final void write(DataOutput out) throws IOException {
        out.writeByte(this.getType());
        this.writeInternal(out);
    }

    public static AbstractTreeNode read(DataInput in) throws IOException {
        AbstractTreeNode node;
        byte type = in.readByte();
        switch (type) {
            case 1: {
                node = new LeafNode();
                break;
            }
            case 2: {
                node = new NumericalNode();
                break;
            }
            case 3: {
                node = new NominalNode();
                break;
            }
            default: {
                throw new IllegalArgumentException(type + " is unknown.");
            }
        }
        node.readFields(in);
        return node;
    }
}

