/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.classification.nn;

import de.jungblut.classification.nn.MultilayerPerceptron;
import de.jungblut.math.DoubleMatrix;
import de.jungblut.math.dense.DenseDoubleMatrix;
import org.apache.commons.math3.random.RandomDataImpl;

public final class WeightMatrix {
    private DoubleMatrix weights;

    public WeightMatrix(int unitsLeftLayer, int unitsRightLayer) {
        this.weights = new DenseDoubleMatrix(unitsRightLayer, unitsLeftLayer + 1);
        double eInit = Math.sqrt(6.0) / Math.sqrt(unitsLeftLayer + unitsRightLayer);
        this.setWeightsUniformly(this.seedRandomGenerator(), eInit);
    }

    private void setWeightsUniformly(RandomDataImpl rnd, double eInit) {
        for (int i = 0; i < this.weights.getColumnCount(); ++i) {
            for (int j = 0; j < this.weights.getRowCount(); ++j) {
                this.weights.set(j, i, rnd.nextUniform(-eInit, eInit));
            }
        }
    }

    private RandomDataImpl seedRandomGenerator() {
        RandomDataImpl rnd = new RandomDataImpl();
        rnd.reSeed(MultilayerPerceptron.SEED);
        rnd.reSeedSecure(MultilayerPerceptron.SEED);
        return rnd;
    }

    public WeightMatrix(DoubleMatrix weights) {
        this.weights = weights;
    }

    public DoubleMatrix getWeights() {
        return this.weights;
    }

    public void setWeights(DoubleMatrix weights) {
        this.weights = weights;
    }

    public String toString() {
        return this.weights.toString();
    }
}

