/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.classification.knn;

import de.jungblut.classification.knn.AbstractKNearestNeighbours;
import de.jungblut.datastructure.DistanceResult;
import de.jungblut.datastructure.InvertedIndex;
import de.jungblut.distance.DistanceMeasurer;
import de.jungblut.jrpt.VectorDistanceTuple;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.named.KeyedDoubleVector;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class SparseKNearestNeighbours
extends AbstractKNearestNeighbours {
    private final InvertedIndex<DoubleVector, Integer> index;
    private final TIntObjectHashMap<DoubleVector> featureOutcomeMap = new TIntObjectHashMap();

    public SparseKNearestNeighbours(int numOutcomes, int k, DistanceMeasurer measurer) {
        super(numOutcomes, k);
        this.index = InvertedIndex.createVectorIndex(measurer);
    }

    @Override
    public void train(Iterable<DoubleVector> features, Iterable<DoubleVector> outcome) {
        ArrayList<KeyedDoubleVector> featureList = new ArrayList<KeyedDoubleVector>();
        Iterator<DoubleVector> featIterator = features.iterator();
        Iterator<DoubleVector> outIterator = outcome.iterator();
        int id = 0;
        while (featIterator.hasNext()) {
            featureList.add(new KeyedDoubleVector(id, featIterator.next()));
            this.featureOutcomeMap.put(id, (Object)outIterator.next());
            ++id;
        }
        this.index.build(featureList);
    }

    @Override
    protected List<VectorDistanceTuple<DoubleVector>> getNearestNeighbours(DoubleVector feature, int k) {
        ArrayList<VectorDistanceTuple<DoubleVector>> neighbours = new ArrayList<VectorDistanceTuple<DoubleVector>>();
        List<DistanceResult<DoubleVector>> result = this.index.query(feature, k, Double.MAX_VALUE);
        for (DistanceResult<DoubleVector> res : result) {
            KeyedDoubleVector resValue = (KeyedDoubleVector)res.get();
            neighbours.add((VectorDistanceTuple<DoubleVector>)new VectorDistanceTuple(res.get(), (Object)((DoubleVector)this.featureOutcomeMap.get(resValue.getKey())), res.getDistance()));
        }
        return neighbours;
    }
}

