/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.classification.knn;

import com.codepoetics.protonpack.StreamUtils;
import de.jungblut.classification.knn.AbstractKNearestNeighbours;
import de.jungblut.jrpt.KDTree;
import de.jungblut.jrpt.VectorDistanceTuple;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.tuple.Tuple;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class KNearestNeighbours
extends AbstractKNearestNeighbours {
    private final KDTree<DoubleVector> tree = new KDTree();

    public KNearestNeighbours(int numOutcomes, int k) {
        super(numOutcomes, k);
    }

    @Override
    public void train(Iterable<DoubleVector> features, Iterable<DoubleVector> outcome) {
        Stream stream = StreamUtils.zip(StreamSupport.stream(features.spliterator(), false), StreamSupport.stream(outcome.spliterator(), false), (l, r) -> new Tuple(l, r));
        this.tree.constructWithPayload(stream);
    }

    @Override
    protected List<VectorDistanceTuple<DoubleVector>> getNearestNeighbours(DoubleVector feature, int k) {
        return this.tree.getNearestNeighbours(feature, k);
    }
}

