/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.classification.eval;

import com.google.common.base.Preconditions;
import de.jungblut.classification.Classifier;
import de.jungblut.classification.eval.EvaluationSplit;
import de.jungblut.classification.eval.Evaluator;
import de.jungblut.classification.eval.WeightMapper;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.minimize.IterationCompletionListener;
import java.util.Comparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestSetIterationCallback<T extends Classifier>
implements IterationCompletionListener {
    private static final Logger LOG = LogManager.getLogger(TestSetIterationCallback.class);
    private final EvaluationSplit split;
    private final WeightMapper<T> mapper;
    private final Comparator<Evaluator.EvaluationResult> resultComparison;
    private Evaluator.EvaluationResult bestResult;
    private DoubleVector bestWeights;
    private int evaluationInterval;

    public TestSetIterationCallback(EvaluationSplit split, WeightMapper<T> mapper, Comparator<Evaluator.EvaluationResult> resultComparison, int evaluationInterval) {
        this.evaluationInterval = evaluationInterval;
        this.resultComparison = (Comparator)Preconditions.checkNotNull(resultComparison, (Object)"resultComparison");
        this.split = (EvaluationSplit)Preconditions.checkNotNull((Object)split, (Object)"split");
        this.mapper = (WeightMapper)Preconditions.checkNotNull(mapper, (Object)"mapper");
    }

    public TestSetIterationCallback(EvaluationSplit split, WeightMapper<T> mapper, Comparator<Evaluator.EvaluationResult> resultComparison) {
        this(split, mapper, resultComparison, 10);
    }

    @Override
    public void onIterationFinished(int iteration, double cost, DoubleVector currentWeights) {
        if (iteration % this.evaluationInterval == 0) {
            T newClassifier = this.mapper.mapWeights(currentWeights);
            Evaluator.EvaluationResult result = Evaluator.testClassifier(newClassifier, this.split.getTestFeatures(), this.split.getTestOutcome());
            if (this.bestResult == null) {
                this.bestResult = result;
                this.bestWeights = currentWeights.deepCopy();
            } else if (this.resultComparison.compare(this.bestResult, result) > 0) {
                LOG.info("Found better weights with result:");
                result.print(LOG);
                this.bestResult = result;
                this.bestWeights = currentWeights.deepCopy();
            }
        }
    }

    public Evaluator.EvaluationResult getBestResult() {
        return this.bestResult;
    }

    public DoubleVector getBestWeights() {
        return this.bestWeights;
    }
}

