/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.classification.eval;

import de.jungblut.classification.Classifier;
import de.jungblut.classification.eval.EvaluationSplit;
import de.jungblut.classification.eval.Evaluator;
import de.jungblut.classification.eval.WeightMapper;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.minimize.IterationCompletionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EvaluationListener<A extends Classifier>
implements IterationCompletionListener {
    private static final Logger LOG = LogManager.getLogger(EvaluationListener.class);
    protected final EvaluationSplit split;
    protected final WeightMapper<A> mapper;
    protected int runInterval = 1;

    public EvaluationListener(WeightMapper<A> mapper, EvaluationSplit split) {
        this(mapper, split, 1);
    }

    public EvaluationListener(WeightMapper<A> mapper, EvaluationSplit split, int runInterval) {
        this.mapper = mapper;
        this.split = split;
        this.runInterval = runInterval;
    }

    @Override
    public void onIterationFinished(int iteration, double cost, DoubleVector currentWeights) {
        if (iteration % this.runInterval == 0) {
            A classifier = this.mapper.mapWeights(currentWeights);
            Evaluator.EvaluationResult testEval = Evaluator.testClassifier(classifier, this.split.getTestFeatures(), this.split.getTestOutcome());
            Evaluator.EvaluationResult trainEval = Evaluator.testClassifier(classifier, this.split.getTrainFeatures(), this.split.getTrainOutcome());
            this.onResult(iteration, cost, trainEval, testEval);
        }
    }

    public final void setRunInterval(int runInterval) {
        this.runInterval = runInterval;
    }

    protected void onResult(int iteration, double cost, Evaluator.EvaluationResult trainEval, Evaluator.EvaluationResult testEval) {
        LOG.info("Iteration " + iteration + " | Validation accuracy: " + trainEval.getAccuracy() + " | Training accuracy: " + testEval.getAccuracy());
    }
}

