/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.classification;

import de.jungblut.classification.Predictor;
import de.jungblut.datastructure.ArrayUtils;
import de.jungblut.math.DoubleVector;

public abstract class AbstractPredictor
implements Predictor {
    @Override
    public int predictedClass(DoubleVector features, double threshold) {
        DoubleVector predict = this.predict(features);
        return this.extractPredictedClass(predict, threshold);
    }

    @Override
    public int predictedClass(DoubleVector features) {
        DoubleVector predict = this.predict(features);
        return this.extractPredictedClass(predict);
    }

    @Override
    public DoubleVector predictProbability(DoubleVector features) {
        DoubleVector predict = this.predict(features);
        return predict.divide(predict.sum());
    }

    @Override
    public int extractPredictedClass(DoubleVector predict) {
        if (predict.getLength() == 1) {
            return (int)Math.rint(predict.get(0));
        }
        return ArrayUtils.maxIndex(predict.toArray());
    }

    @Override
    public int extractPredictedClass(DoubleVector predict, double threshold) {
        if (predict.getLength() == 1) {
            if (predict.get(0) <= threshold) {
                return 0;
            }
            return 1;
        }
        return ArrayUtils.maxIndex(predict.toArray());
    }
}

